/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.BackupDescription;
import com.amazonaws.services.dynamodbv2.model.transform.BackupDetailsJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.SourceTableDetailsJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.SourceTableFeatureDetailsJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class BackupDescriptionJsonUnmarshaller
implements Unmarshaller<BackupDescription, JsonUnmarshallerContext> {
    private static BackupDescriptionJsonUnmarshaller instance;

    BackupDescriptionJsonUnmarshaller() {
    }

    public BackupDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        BackupDescription backupDescription = new BackupDescription();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("BackupDetails")) {
                backupDescription.setBackupDetails(BackupDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("SourceTableDetails")) {
                backupDescription.setSourceTableDetails(SourceTableDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("SourceTableFeatureDetails")) {
                backupDescription.setSourceTableFeatureDetails(SourceTableFeatureDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return backupDescription;
    }

    public static BackupDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BackupDescriptionJsonUnmarshaller();
        }
        return instance;
    }
}

