/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AutoScalingPolicyDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoScalingSettingsDescription
implements Serializable {
    private Long minimumUnits;
    private Long maximumUnits;
    private Boolean autoScalingDisabled;
    private String autoScalingRoleArn;
    private List<AutoScalingPolicyDescription> scalingPolicies;

    public Long getMinimumUnits() {
        return this.minimumUnits;
    }

    public void setMinimumUnits(Long minimumUnits) {
        this.minimumUnits = minimumUnits;
    }

    public AutoScalingSettingsDescription withMinimumUnits(Long minimumUnits) {
        this.minimumUnits = minimumUnits;
        return this;
    }

    public Long getMaximumUnits() {
        return this.maximumUnits;
    }

    public void setMaximumUnits(Long maximumUnits) {
        this.maximumUnits = maximumUnits;
    }

    public AutoScalingSettingsDescription withMaximumUnits(Long maximumUnits) {
        this.maximumUnits = maximumUnits;
        return this;
    }

    public Boolean isAutoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public Boolean getAutoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public void setAutoScalingDisabled(Boolean autoScalingDisabled) {
        this.autoScalingDisabled = autoScalingDisabled;
    }

    public AutoScalingSettingsDescription withAutoScalingDisabled(Boolean autoScalingDisabled) {
        this.autoScalingDisabled = autoScalingDisabled;
        return this;
    }

    public String getAutoScalingRoleArn() {
        return this.autoScalingRoleArn;
    }

    public void setAutoScalingRoleArn(String autoScalingRoleArn) {
        this.autoScalingRoleArn = autoScalingRoleArn;
    }

    public AutoScalingSettingsDescription withAutoScalingRoleArn(String autoScalingRoleArn) {
        this.autoScalingRoleArn = autoScalingRoleArn;
        return this;
    }

    public List<AutoScalingPolicyDescription> getScalingPolicies() {
        return this.scalingPolicies;
    }

    public void setScalingPolicies(Collection<AutoScalingPolicyDescription> scalingPolicies) {
        if (scalingPolicies == null) {
            this.scalingPolicies = null;
            return;
        }
        this.scalingPolicies = new ArrayList<AutoScalingPolicyDescription>(scalingPolicies);
    }

    public AutoScalingSettingsDescription withScalingPolicies(AutoScalingPolicyDescription ... scalingPolicies) {
        if (this.getScalingPolicies() == null) {
            this.scalingPolicies = new ArrayList<AutoScalingPolicyDescription>(scalingPolicies.length);
        }
        for (AutoScalingPolicyDescription value : scalingPolicies) {
            this.scalingPolicies.add(value);
        }
        return this;
    }

    public AutoScalingSettingsDescription withScalingPolicies(Collection<AutoScalingPolicyDescription> scalingPolicies) {
        this.setScalingPolicies(scalingPolicies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMinimumUnits() != null) {
            sb.append("MinimumUnits: " + this.getMinimumUnits() + ",");
        }
        if (this.getMaximumUnits() != null) {
            sb.append("MaximumUnits: " + this.getMaximumUnits() + ",");
        }
        if (this.getAutoScalingDisabled() != null) {
            sb.append("AutoScalingDisabled: " + this.getAutoScalingDisabled() + ",");
        }
        if (this.getAutoScalingRoleArn() != null) {
            sb.append("AutoScalingRoleArn: " + this.getAutoScalingRoleArn() + ",");
        }
        if (this.getScalingPolicies() != null) {
            sb.append("ScalingPolicies: " + this.getScalingPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMinimumUnits() == null ? 0 : this.getMinimumUnits().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumUnits() == null ? 0 : this.getMaximumUnits().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingDisabled() == null ? 0 : this.getAutoScalingDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingRoleArn() == null ? 0 : this.getAutoScalingRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPolicies() == null ? 0 : this.getScalingPolicies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettingsDescription)) {
            return false;
        }
        AutoScalingSettingsDescription other = (AutoScalingSettingsDescription)obj;
        if (other.getMinimumUnits() == null ^ this.getMinimumUnits() == null) {
            return false;
        }
        if (other.getMinimumUnits() != null && !other.getMinimumUnits().equals(this.getMinimumUnits())) {
            return false;
        }
        if (other.getMaximumUnits() == null ^ this.getMaximumUnits() == null) {
            return false;
        }
        if (other.getMaximumUnits() != null && !other.getMaximumUnits().equals(this.getMaximumUnits())) {
            return false;
        }
        if (other.getAutoScalingDisabled() == null ^ this.getAutoScalingDisabled() == null) {
            return false;
        }
        if (other.getAutoScalingDisabled() != null && !other.getAutoScalingDisabled().equals(this.getAutoScalingDisabled())) {
            return false;
        }
        if (other.getAutoScalingRoleArn() == null ^ this.getAutoScalingRoleArn() == null) {
            return false;
        }
        if (other.getAutoScalingRoleArn() != null && !other.getAutoScalingRoleArn().equals(this.getAutoScalingRoleArn())) {
            return false;
        }
        if (other.getScalingPolicies() == null ^ this.getScalingPolicies() == null) {
            return false;
        }
        return other.getScalingPolicies() == null || other.getScalingPolicies().equals(this.getScalingPolicies());
    }
}

