/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class KeysAndAttributes
implements Serializable {
    private ListWithAutoConstructFlag<Map<String, AttributeValue>> keys;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Boolean consistentRead;

    public List<Map<String, AttributeValue>> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<Map<String, AttributeValue>> collection) {
        if (collection == null) {
            this.keys = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keys = listWithAutoConstructFlag;
    }

    public KeysAndAttributes withKeys(Map<String, AttributeValue> ... mapArray) {
        if (this.getKeys() == null) {
            this.setKeys(new ArrayList<Map<String, AttributeValue>>(mapArray.length));
        }
        for (Map<String, AttributeValue> map : mapArray) {
            this.getKeys().add(map);
        }
        return this;
    }

    public KeysAndAttributes withKeys(Collection<Map<String, AttributeValue>> collection) {
        if (collection == null) {
            this.keys = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keys = listWithAutoConstructFlag;
        }
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributesToGet = listWithAutoConstructFlag;
    }

    public KeysAndAttributes withAttributesToGet(String ... stringArray) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getAttributesToGet().add(string);
        }
        return this;
    }

    public KeysAndAttributes withAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributesToGet = listWithAutoConstructFlag;
        }
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean bl) {
        this.consistentRead = bl;
    }

    public KeysAndAttributes withConsistentRead(Boolean bl) {
        this.consistentRead = bl;
        return this;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeys() != null) {
            stringBuilder.append("Keys: " + this.getKeys() + ",");
        }
        if (this.getAttributesToGet() != null) {
            stringBuilder.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.isConsistentRead() != null) {
            stringBuilder.append("ConsistentRead: " + this.isConsistentRead());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getKeys() == null ? 0 : ((Object)this.getKeys()).hashCode());
        n = 31 * n + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        n = 31 * n + (this.isConsistentRead() == null ? 0 : this.isConsistentRead().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof KeysAndAttributes)) {
            return false;
        }
        KeysAndAttributes keysAndAttributes = (KeysAndAttributes)object;
        if (keysAndAttributes.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (keysAndAttributes.getKeys() != null && !((Object)keysAndAttributes.getKeys()).equals(this.getKeys())) {
            return false;
        }
        if (keysAndAttributes.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (keysAndAttributes.getAttributesToGet() != null && !((Object)keysAndAttributes.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (keysAndAttributes.isConsistentRead() == null ^ this.isConsistentRead() == null) {
            return false;
        }
        return keysAndAttributes.isConsistentRead() == null || keysAndAttributes.isConsistentRead().equals(this.isConsistentRead());
    }
}

