/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemCollectionMetrics
implements Serializable {
    private Map<String, AttributeValue> itemCollectionKey;
    private ListWithAutoConstructFlag<Double> sizeEstimateRangeGB;

    public Map<String, AttributeValue> getItemCollectionKey() {
        return this.itemCollectionKey;
    }

    public void setItemCollectionKey(Map<String, AttributeValue> map) {
        this.itemCollectionKey = map;
    }

    public ItemCollectionMetrics withItemCollectionKey(Map<String, AttributeValue> map) {
        this.setItemCollectionKey(map);
        return this;
    }

    public ItemCollectionMetrics addItemCollectionKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.itemCollectionKey) {
            this.itemCollectionKey = new HashMap<String, AttributeValue>();
        }
        if (this.itemCollectionKey.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.itemCollectionKey.put(string, attributeValue);
        return this;
    }

    public ItemCollectionMetrics clearItemCollectionKeyEntries() {
        this.itemCollectionKey = null;
        return this;
    }

    public List<Double> getSizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public void setSizeEstimateRangeGB(Collection<Double> collection) {
        if (collection == null) {
            this.sizeEstimateRangeGB = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.sizeEstimateRangeGB = listWithAutoConstructFlag;
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Double ... doubleArray) {
        if (this.getSizeEstimateRangeGB() == null) {
            this.setSizeEstimateRangeGB(new ArrayList<Double>(doubleArray.length));
        }
        for (Double d : doubleArray) {
            this.getSizeEstimateRangeGB().add(d);
        }
        return this;
    }

    public ItemCollectionMetrics withSizeEstimateRangeGB(Collection<Double> collection) {
        if (collection == null) {
            this.sizeEstimateRangeGB = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.sizeEstimateRangeGB = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getItemCollectionKey() != null) {
            stringBuilder.append("ItemCollectionKey: " + this.getItemCollectionKey() + ",");
        }
        if (this.getSizeEstimateRangeGB() != null) {
            stringBuilder.append("SizeEstimateRangeGB: " + this.getSizeEstimateRangeGB());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItemCollectionKey() == null ? 0 : ((Object)this.getItemCollectionKey()).hashCode());
        n = 31 * n + (this.getSizeEstimateRangeGB() == null ? 0 : ((Object)this.getSizeEstimateRangeGB()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics itemCollectionMetrics = (ItemCollectionMetrics)object;
        if (itemCollectionMetrics.getItemCollectionKey() == null ^ this.getItemCollectionKey() == null) {
            return false;
        }
        if (itemCollectionMetrics.getItemCollectionKey() != null && !((Object)itemCollectionMetrics.getItemCollectionKey()).equals(this.getItemCollectionKey())) {
            return false;
        }
        if (itemCollectionMetrics.getSizeEstimateRangeGB() == null ^ this.getSizeEstimateRangeGB() == null) {
            return false;
        }
        return itemCollectionMetrics.getSizeEstimateRangeGB() == null || ((Object)itemCollectionMetrics.getSizeEstimateRangeGB()).equals(this.getSizeEstimateRangeGB());
    }
}

