/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DeleteItemResult
implements Serializable {
    private Map<String, AttributeValue> attributes;
    private ConsumedCapacity consumedCapacity;
    private ItemCollectionMetrics itemCollectionMetrics;

    public Map<String, AttributeValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeValue> map) {
        this.attributes = map;
    }

    public DeleteItemResult withAttributes(Map<String, AttributeValue> map) {
        this.setAttributes(map);
        return this;
    }

    public DeleteItemResult addAttributesEntry(String string, AttributeValue attributeValue) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, AttributeValue>();
        }
        if (this.attributes.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.attributes.put(string, attributeValue);
        return this;
    }

    public DeleteItemResult clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public DeleteItemResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public ItemCollectionMetrics getItemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public void setItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
    }

    public DeleteItemResult withItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getAttributes() != null) {
            stringBuilder.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            stringBuilder.append("ConsumedCapacity: " + this.getConsumedCapacity() + ",");
        }
        if (this.getItemCollectionMetrics() != null) {
            stringBuilder.append("ItemCollectionMetrics: " + this.getItemCollectionMetrics());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        n = 31 * n + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        n = 31 * n + (this.getItemCollectionMetrics() == null ? 0 : this.getItemCollectionMetrics().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DeleteItemResult)) {
            return false;
        }
        DeleteItemResult deleteItemResult = (DeleteItemResult)object;
        if (deleteItemResult.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (deleteItemResult.getAttributes() != null && !((Object)deleteItemResult.getAttributes()).equals(this.getAttributes())) {
            return false;
        }
        if (deleteItemResult.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        if (deleteItemResult.getConsumedCapacity() != null && !deleteItemResult.getConsumedCapacity().equals(this.getConsumedCapacity())) {
            return false;
        }
        if (deleteItemResult.getItemCollectionMetrics() == null ^ this.getItemCollectionMetrics() == null) {
            return false;
        }
        return deleteItemResult.getItemCollectionMetrics() == null || deleteItemResult.getItemCollectionMetrics().equals(this.getItemCollectionMetrics());
    }
}

