/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DeleteItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private Map<String, AttributeValue> key;
    private Map<String, ExpectedAttributeValue> expected;
    private String conditionalOperator;
    private String returnValues;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;

    public DeleteItemRequest() {
    }

    public DeleteItemRequest(String string, Map<String, AttributeValue> map) {
        this.setTableName(string);
        this.setKey(map);
    }

    public DeleteItemRequest(String string, Map<String, AttributeValue> map, String string2) {
        this.setTableName(string);
        this.setKey(map);
        this.setReturnValues(string2);
    }

    public DeleteItemRequest(String string, Map<String, AttributeValue> map, ReturnValue returnValue) {
        this.tableName = string;
        this.key = map;
        this.returnValues = returnValue.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public DeleteItemRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Map<String, AttributeValue> getKey() {
        return this.key;
    }

    public void setKey(Map<String, AttributeValue> map) {
        this.key = map;
    }

    public DeleteItemRequest withKey(Map<String, AttributeValue> map) {
        this.setKey(map);
        return this;
    }

    public void setKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        HashMap<String, AttributeValue> hashMap = new HashMap<String, AttributeValue>();
        if (entry == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        hashMap.put(entry.getKey(), entry.getValue());
        if (entry2 != null) {
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setKey(hashMap);
    }

    public DeleteItemRequest withKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        this.setKey(entry, entry2);
        return this;
    }

    public DeleteItemRequest addKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.key) {
            this.key = new HashMap<String, AttributeValue>();
        }
        if (this.key.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.key.put(string, attributeValue);
        return this;
    }

    public DeleteItemRequest clearKeyEntries() {
        this.key = null;
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> map) {
        this.expected = map;
    }

    public DeleteItemRequest withExpected(Map<String, ExpectedAttributeValue> map) {
        this.setExpected(map);
        return this;
    }

    public DeleteItemRequest addExpectedEntry(String string, ExpectedAttributeValue expectedAttributeValue) {
        if (null == this.expected) {
            this.expected = new HashMap<String, ExpectedAttributeValue>();
        }
        if (this.expected.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.expected.put(string, expectedAttributeValue);
        return this;
    }

    public DeleteItemRequest clearExpectedEntries() {
        this.expected = null;
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public DeleteItemRequest withConditionalOperator(String string) {
        this.conditionalOperator = string;
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public DeleteItemRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(String string) {
        this.returnValues = string;
    }

    public DeleteItemRequest withReturnValues(String string) {
        this.returnValues = string;
        return this;
    }

    public void setReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
    }

    public DeleteItemRequest withReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public DeleteItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public DeleteItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public void setReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
    }

    public DeleteItemRequest withReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
        return this;
    }

    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
    }

    public DeleteItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKey() != null) {
            stringBuilder.append("Key: " + this.getKey() + ",");
        }
        if (this.getExpected() != null) {
            stringBuilder.append("Expected: " + this.getExpected() + ",");
        }
        if (this.getConditionalOperator() != null) {
            stringBuilder.append("ConditionalOperator: " + this.getConditionalOperator() + ",");
        }
        if (this.getReturnValues() != null) {
            stringBuilder.append("ReturnValues: " + this.getReturnValues() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            stringBuilder.append("ReturnItemCollectionMetrics: " + this.getReturnItemCollectionMetrics());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getKey() == null ? 0 : ((Object)this.getKey()).hashCode());
        n = 31 * n + (this.getExpected() == null ? 0 : ((Object)this.getExpected()).hashCode());
        n = 31 * n + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        n = 31 * n + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        n = 31 * n + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DeleteItemRequest)) {
            return false;
        }
        DeleteItemRequest deleteItemRequest = (DeleteItemRequest)object;
        if (deleteItemRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (deleteItemRequest.getTableName() != null && !deleteItemRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (deleteItemRequest.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (deleteItemRequest.getKey() != null && !((Object)deleteItemRequest.getKey()).equals(this.getKey())) {
            return false;
        }
        if (deleteItemRequest.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (deleteItemRequest.getExpected() != null && !((Object)deleteItemRequest.getExpected()).equals(this.getExpected())) {
            return false;
        }
        if (deleteItemRequest.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (deleteItemRequest.getConditionalOperator() != null && !deleteItemRequest.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (deleteItemRequest.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        if (deleteItemRequest.getReturnValues() != null && !deleteItemRequest.getReturnValues().equals(this.getReturnValues())) {
            return false;
        }
        if (deleteItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (deleteItemRequest.getReturnConsumedCapacity() != null && !deleteItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (deleteItemRequest.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        return deleteItemRequest.getReturnItemCollectionMetrics() == null || deleteItemRequest.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics());
    }
}

