/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Map<String, List<WriteRequest>> requestItems;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;

    public BatchWriteItemRequest() {
    }

    public BatchWriteItemRequest(Map<String, List<WriteRequest>> map) {
        this.setRequestItems(map);
    }

    public Map<String, List<WriteRequest>> getRequestItems() {
        return this.requestItems;
    }

    public void setRequestItems(Map<String, List<WriteRequest>> map) {
        this.requestItems = map;
    }

    public BatchWriteItemRequest withRequestItems(Map<String, List<WriteRequest>> map) {
        this.setRequestItems(map);
        return this;
    }

    public BatchWriteItemRequest addRequestItemsEntry(String string, List<WriteRequest> list) {
        if (null == this.requestItems) {
            this.requestItems = new HashMap<String, List<WriteRequest>>();
        }
        if (this.requestItems.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.requestItems.put(string, list);
        return this;
    }

    public BatchWriteItemRequest clearRequestItemsEntries() {
        this.requestItems = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public BatchWriteItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public BatchWriteItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public void setReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
    }

    public BatchWriteItemRequest withReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
        return this;
    }

    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
    }

    public BatchWriteItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getRequestItems() != null) {
            stringBuilder.append("RequestItems: " + this.getRequestItems() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            stringBuilder.append("ReturnItemCollectionMetrics: " + this.getReturnItemCollectionMetrics());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getRequestItems() == null ? 0 : ((Object)this.getRequestItems()).hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        n = 31 * n + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)object;
        if (batchWriteItemRequest.getRequestItems() == null ^ this.getRequestItems() == null) {
            return false;
        }
        if (batchWriteItemRequest.getRequestItems() != null && !((Object)batchWriteItemRequest.getRequestItems()).equals(this.getRequestItems())) {
            return false;
        }
        if (batchWriteItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (batchWriteItemRequest.getReturnConsumedCapacity() != null && !batchWriteItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (batchWriteItemRequest.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        return batchWriteItemRequest.getReturnItemCollectionMetrics() == null || batchWriteItemRequest.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics());
    }
}

