/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.metrics.DynamoDBRequestMetric;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchGetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.BatchWriteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionalCheckFailedExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.CreateTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DescribeTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.DescribeTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GetItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ItemCollectionSizeLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ListTablesRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.QueryRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.QueryResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ScanRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ScanResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateItemRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateTableRequestMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AmazonDynamoDBClient
extends AmazonWebServiceClient
implements AmazonDynamoDB {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log;
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonDynamoDBClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonDynamoDBClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDynamoDBClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new ClientConfiguration());
    }

    public AmazonDynamoDBClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonDynamoDBClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(aWSCredentials);
        this.init();
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, new ClientConfiguration());
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, null);
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonDynamoDBClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ProvisionedThroughputExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ItemCollectionSizeLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ConditionalCheckFailedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("dynamodb.us-east-1.amazonaws.com/");
        HandlerChainFactory handlerChainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandlerChain("/com/amazonaws/services/dynamodbv2/request.handlers"));
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandler2Chain("/com/amazonaws/services/dynamodbv2/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration clientConfiguration) {
        ClientConfiguration clientConfiguration2 = clientConfiguration;
        clientConfiguration2 = new ClientConfiguration(clientConfiguration);
        if (clientConfiguration2.getRetryPolicy() == PredefinedRetryPolicies.DEFAULT) {
            clientConfiguration2.setRetryPolicy(PredefinedRetryPolicies.DYNAMODB_DEFAULT);
        }
        return clientConfiguration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult scan(ScanRequest scanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(scanRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ScanRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ScanRequestMarshaller().marshall(scanRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ScanResultJsonUnmarshaller scanResultJsonUnmarshaller = new ScanResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)scanResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            ScanResult scanResult = (ScanResult)response.getAwsResponse();
            return scanResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTableRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTableRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTableRequestMarshaller().marshall(updateTableRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateTableResultJsonUnmarshaller updateTableResultJsonUnmarshaller = new UpdateTableResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)updateTableResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            UpdateTableResult updateTableResult = (UpdateTableResult)response.getAwsResponse();
            return updateTableResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTableRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTableRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTableRequestMarshaller().marshall(deleteTableRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteTableResultJsonUnmarshaller deleteTableResultJsonUnmarshaller = new DeleteTableResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)deleteTableResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DeleteTableResult deleteTableResult = (DeleteTableResult)response.getAwsResponse();
            return deleteTableResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchWriteItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchWriteItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchWriteItemRequestMarshaller().marshall(batchWriteItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            BatchWriteItemResultJsonUnmarshaller batchWriteItemResultJsonUnmarshaller = new BatchWriteItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)batchWriteItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            BatchWriteItemResult batchWriteItemResult = (BatchWriteItemResult)response.getAwsResponse();
            return batchWriteItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTableRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTableRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTableRequestMarshaller().marshall(describeTableRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeTableResultJsonUnmarshaller describeTableResultJsonUnmarshaller = new DescribeTableResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)describeTableResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DescribeTableResult describeTableResult = (DescribeTableResult)response.getAwsResponse();
            return describeTableResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetItemResult getItem(GetItemRequest getItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetItemRequestMarshaller().marshall(getItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetItemResultJsonUnmarshaller getItemResultJsonUnmarshaller = new GetItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)getItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            GetItemResult getItemResult = (GetItemResult)response.getAwsResponse();
            return getItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteItemRequestMarshaller().marshall(deleteItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteItemResultJsonUnmarshaller deleteItemResultJsonUnmarshaller = new DeleteItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)deleteItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            DeleteItemResult deleteItemResult = (DeleteItemResult)response.getAwsResponse();
            return deleteItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableResult createTable(CreateTableRequest createTableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTableRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTableRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTableRequestMarshaller().marshall(createTableRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateTableResultJsonUnmarshaller createTableResultJsonUnmarshaller = new CreateTableResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)createTableResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            CreateTableResult createTableResult = (CreateTableResult)response.getAwsResponse();
            return createTableResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult query(QueryRequest queryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(queryRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<QueryRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new QueryRequestMarshaller().marshall(queryRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            QueryResultJsonUnmarshaller queryResultJsonUnmarshaller = new QueryResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)queryResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            QueryResult queryResult = (QueryResult)response.getAwsResponse();
            return queryResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutItemResult putItem(PutItemRequest putItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutItemRequestMarshaller().marshall(putItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PutItemResultJsonUnmarshaller putItemResultJsonUnmarshaller = new PutItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)putItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            PutItemResult putItemResult = (PutItemResult)response.getAwsResponse();
            return putItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResult listTables(ListTablesRequest listTablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTablesRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTablesRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTablesRequestMarshaller().marshall(listTablesRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListTablesResultJsonUnmarshaller listTablesResultJsonUnmarshaller = new ListTablesResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)listTablesResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            ListTablesResult listTablesResult = (ListTablesResult)response.getAwsResponse();
            return listTablesResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateItemRequestMarshaller().marshall(updateItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateItemResultJsonUnmarshaller updateItemResultJsonUnmarshaller = new UpdateItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)updateItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            UpdateItemResult updateItemResult = (UpdateItemResult)response.getAwsResponse();
            return updateItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetItemRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetItemRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetItemRequestMarshaller().marshall(batchGetItemRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            BatchGetItemResultJsonUnmarshaller batchGetItemResultJsonUnmarshaller = new BatchGetItemResultJsonUnmarshaller();
            JsonResponseHandler jsonResponseHandler = new JsonResponseHandler((Unmarshaller)batchGetItemResultJsonUnmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)jsonResponseHandler, executionContext);
            BatchGetItemResult batchGetItemResult = (BatchGetItemResult)response.getAwsResponse();
            return batchGetItemResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        return this.listTables(new ListTablesRequest());
    }

    @Override
    public ScanResult scan(String string, List<String> list) throws AmazonServiceException, AmazonClientException {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(string);
        scanRequest.setAttributesToGet(list);
        return this.scan(scanRequest);
    }

    @Override
    public ScanResult scan(String string, Map<String, Condition> map) throws AmazonServiceException, AmazonClientException {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(string);
        scanRequest.setScanFilter(map);
        return this.scan(scanRequest);
    }

    @Override
    public ScanResult scan(String string, List<String> list, Map<String, Condition> map) throws AmazonServiceException, AmazonClientException {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(string);
        scanRequest.setAttributesToGet(list);
        scanRequest.setScanFilter(map);
        return this.scan(scanRequest);
    }

    @Override
    public UpdateTableResult updateTable(String string, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        UpdateTableRequest updateTableRequest = new UpdateTableRequest();
        updateTableRequest.setTableName(string);
        updateTableRequest.setProvisionedThroughput(provisionedThroughput);
        return this.updateTable(updateTableRequest);
    }

    @Override
    public DeleteTableResult deleteTable(String string) throws AmazonServiceException, AmazonClientException {
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest();
        deleteTableRequest.setTableName(string);
        return this.deleteTable(deleteTableRequest);
    }

    @Override
    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> map) throws AmazonServiceException, AmazonClientException {
        BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest();
        batchWriteItemRequest.setRequestItems(map);
        return this.batchWriteItem(batchWriteItemRequest);
    }

    @Override
    public DescribeTableResult describeTable(String string) throws AmazonServiceException, AmazonClientException {
        DescribeTableRequest describeTableRequest = new DescribeTableRequest();
        describeTableRequest.setTableName(string);
        return this.describeTable(describeTableRequest);
    }

    @Override
    public GetItemResult getItem(String string, Map<String, AttributeValue> map) throws AmazonServiceException, AmazonClientException {
        GetItemRequest getItemRequest = new GetItemRequest();
        getItemRequest.setTableName(string);
        getItemRequest.setKey(map);
        return this.getItem(getItemRequest);
    }

    @Override
    public GetItemResult getItem(String string, Map<String, AttributeValue> map, Boolean bl) throws AmazonServiceException, AmazonClientException {
        GetItemRequest getItemRequest = new GetItemRequest();
        getItemRequest.setTableName(string);
        getItemRequest.setKey(map);
        getItemRequest.setConsistentRead(bl);
        return this.getItem(getItemRequest);
    }

    @Override
    public DeleteItemResult deleteItem(String string, Map<String, AttributeValue> map) throws AmazonServiceException, AmazonClientException {
        DeleteItemRequest deleteItemRequest = new DeleteItemRequest();
        deleteItemRequest.setTableName(string);
        deleteItemRequest.setKey(map);
        return this.deleteItem(deleteItemRequest);
    }

    @Override
    public DeleteItemResult deleteItem(String string, Map<String, AttributeValue> map, String string2) throws AmazonServiceException, AmazonClientException {
        DeleteItemRequest deleteItemRequest = new DeleteItemRequest();
        deleteItemRequest.setTableName(string);
        deleteItemRequest.setKey(map);
        deleteItemRequest.setReturnValues(string2);
        return this.deleteItem(deleteItemRequest);
    }

    @Override
    public CreateTableResult createTable(List<AttributeDefinition> list, String string, List<KeySchemaElement> list2, ProvisionedThroughput provisionedThroughput) throws AmazonServiceException, AmazonClientException {
        CreateTableRequest createTableRequest = new CreateTableRequest();
        createTableRequest.setAttributeDefinitions(list);
        createTableRequest.setTableName(string);
        createTableRequest.setKeySchema(list2);
        createTableRequest.setProvisionedThroughput(provisionedThroughput);
        return this.createTable(createTableRequest);
    }

    @Override
    public PutItemResult putItem(String string, Map<String, AttributeValue> map) throws AmazonServiceException, AmazonClientException {
        PutItemRequest putItemRequest = new PutItemRequest();
        putItemRequest.setTableName(string);
        putItemRequest.setItem(map);
        return this.putItem(putItemRequest);
    }

    @Override
    public PutItemResult putItem(String string, Map<String, AttributeValue> map, String string2) throws AmazonServiceException, AmazonClientException {
        PutItemRequest putItemRequest = new PutItemRequest();
        putItemRequest.setTableName(string);
        putItemRequest.setItem(map);
        putItemRequest.setReturnValues(string2);
        return this.putItem(putItemRequest);
    }

    @Override
    public ListTablesResult listTables(String string) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest listTablesRequest = new ListTablesRequest();
        listTablesRequest.setExclusiveStartTableName(string);
        return this.listTables(listTablesRequest);
    }

    @Override
    public ListTablesResult listTables(String string, Integer n) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest listTablesRequest = new ListTablesRequest();
        listTablesRequest.setExclusiveStartTableName(string);
        listTablesRequest.setLimit(n);
        return this.listTables(listTablesRequest);
    }

    @Override
    public ListTablesResult listTables(Integer n) throws AmazonServiceException, AmazonClientException {
        ListTablesRequest listTablesRequest = new ListTablesRequest();
        listTablesRequest.setLimit(n);
        return this.listTables(listTablesRequest);
    }

    @Override
    public UpdateItemResult updateItem(String string, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map2) throws AmazonServiceException, AmazonClientException {
        UpdateItemRequest updateItemRequest = new UpdateItemRequest();
        updateItemRequest.setTableName(string);
        updateItemRequest.setKey(map);
        updateItemRequest.setAttributeUpdates(map2);
        return this.updateItem(updateItemRequest);
    }

    @Override
    public UpdateItemResult updateItem(String string, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map2, String string2) throws AmazonServiceException, AmazonClientException {
        UpdateItemRequest updateItemRequest = new UpdateItemRequest();
        updateItemRequest.setTableName(string);
        updateItemRequest.setKey(map);
        updateItemRequest.setAttributeUpdates(map2);
        updateItemRequest.setReturnValues(string2);
        return this.updateItem(updateItemRequest);
    }

    @Override
    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> map, String string) throws AmazonServiceException, AmazonClientException {
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest();
        batchGetItemRequest.setRequestItems(map);
        batchGetItemRequest.setReturnConsumedCapacity(string);
        return this.batchGetItem(batchGetItemRequest);
    }

    @Override
    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> map) throws AmazonServiceException, AmazonClientException {
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest();
        batchGetItemRequest.setRequestItems(map);
        return this.batchGetItem(batchGetItemRequest);
    }

    @Override
    public void setEndpoint(String string) {
        super.setEndpoint(string);
    }

    public void setEndpoint(String string, String string2, String string3) throws IllegalArgumentException {
        super.setEndpoint(string, string2, string3);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.client.getResponseMetadataForRequest(amazonWebServiceRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, ExecutionContext executionContext) {
        AWSCredentials aWSCredentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            aWSCredentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            aWSRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        if (amazonWebServiceRequest != null && amazonWebServiceRequest.getRequestCredentials() != null) {
            aWSCredentials = amazonWebServiceRequest.getRequestCredentials();
        }
        executionContext.setCredentials(aWSCredentials);
        JsonErrorResponseHandler jsonErrorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response response = this.client.execute(request, httpResponseHandler, (HttpResponseHandler)jsonErrorResponseHandler, executionContext);
        return response;
    }

    static {
        AwsSdkMetrics.addAll(Arrays.asList(DynamoDBRequestMetric.values()));
        log = LogFactory.getLog(AmazonDynamoDB.class);
    }
}

