/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;

public class Tables {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;

    public static boolean doesTableExist(AmazonDynamoDB amazonDynamoDB, String string) {
        try {
            TableDescription tableDescription = amazonDynamoDB.describeTable(new DescribeTableRequest(string)).getTable();
            return TableStatus.ACTIVE.toString().equals(tableDescription.getTableStatus());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return false;
        }
    }

    public static void waitForTableToBecomeActive(AmazonDynamoDB amazonDynamoDB, String string) {
        Tables.waitForTableToBecomeActive(amazonDynamoDB, string, 600000, 20000);
    }

    public static void waitForTableToBecomeActive(AmazonDynamoDB amazonDynamoDB, String string, int n, int n2) {
        if (n < 0) {
            throw new AmazonClientException("Timeout must be >= 0");
        }
        if (n2 <= 0 || n2 >= n) {
            throw new AmazonClientException("Interval must be > 0 and < timeout");
        }
        long l = System.currentTimeMillis();
        long l2 = l + (long)n;
        while (System.currentTimeMillis() < l2) {
            try {
                TableDescription tableDescription = amazonDynamoDB.describeTable(new DescribeTableRequest(string)).getTable();
                if (tableDescription != null && tableDescription.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
                    return;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                throw new AmazonClientException("Interrupted while waiting for table to become active", (Throwable)interruptedException);
            }
        }
        throw new AmazonClientException("Table " + string + " never became active");
    }
}

