/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutRequest
implements Serializable {
    private Map<String, AttributeValue> item;

    public PutRequest() {
    }

    public PutRequest(Map<String, AttributeValue> map) {
        this.setItem(map);
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> map) {
        this.item = map;
    }

    public PutRequest withItem(Map<String, AttributeValue> map) {
        this.setItem(map);
        return this;
    }

    public PutRequest addItemEntry(String string, AttributeValue attributeValue) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.item.put(string, attributeValue);
        return this;
    }

    public PutRequest clearItemEntries() {
        this.item = null;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getItem() != null) {
            stringBuilder.append("Item: " + this.getItem());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItem() == null ? 0 : ((Object)this.getItem()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PutRequest)) {
            return false;
        }
        PutRequest putRequest = (PutRequest)object;
        if (putRequest.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        return putRequest.getItem() == null || ((Object)putRequest.getItem()).equals(this.getItem());
    }
}

