/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private Map<String, AttributeValue> item;
    private Map<String, ExpectedAttributeValue> expected;
    private String returnValues;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;
    private String conditionalOperator;

    public PutItemRequest() {
    }

    public PutItemRequest(String string, Map<String, AttributeValue> map) {
        this.setTableName(string);
        this.setItem(map);
    }

    public PutItemRequest(String string, Map<String, AttributeValue> map, String string2) {
        this.setTableName(string);
        this.setItem(map);
        this.setReturnValues(string2);
    }

    public PutItemRequest(String string, Map<String, AttributeValue> map, ReturnValue returnValue) {
        this.tableName = string;
        this.item = map;
        this.returnValues = returnValue.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public PutItemRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> map) {
        this.item = map;
    }

    public PutItemRequest withItem(Map<String, AttributeValue> map) {
        this.setItem(map);
        return this;
    }

    public PutItemRequest addItemEntry(String string, AttributeValue attributeValue) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.item.put(string, attributeValue);
        return this;
    }

    public PutItemRequest clearItemEntries() {
        this.item = null;
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> map) {
        this.expected = map;
    }

    public PutItemRequest withExpected(Map<String, ExpectedAttributeValue> map) {
        this.setExpected(map);
        return this;
    }

    public PutItemRequest addExpectedEntry(String string, ExpectedAttributeValue expectedAttributeValue) {
        if (null == this.expected) {
            this.expected = new HashMap<String, ExpectedAttributeValue>();
        }
        if (this.expected.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.expected.put(string, expectedAttributeValue);
        return this;
    }

    public PutItemRequest clearExpectedEntries() {
        this.expected = null;
        return this;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(String string) {
        this.returnValues = string;
    }

    public PutItemRequest withReturnValues(String string) {
        this.returnValues = string;
        return this;
    }

    public void setReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
    }

    public PutItemRequest withReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public PutItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public PutItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public void setReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
    }

    public PutItemRequest withReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
        return this;
    }

    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
    }

    public PutItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public PutItemRequest withConditionalOperator(String string) {
        this.conditionalOperator = string;
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public PutItemRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getItem() != null) {
            stringBuilder.append("Item: " + this.getItem() + ",");
        }
        if (this.getExpected() != null) {
            stringBuilder.append("Expected: " + this.getExpected() + ",");
        }
        if (this.getReturnValues() != null) {
            stringBuilder.append("ReturnValues: " + this.getReturnValues() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            stringBuilder.append("ReturnItemCollectionMetrics: " + this.getReturnItemCollectionMetrics() + ",");
        }
        if (this.getConditionalOperator() != null) {
            stringBuilder.append("ConditionalOperator: " + this.getConditionalOperator());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getItem() == null ? 0 : ((Object)this.getItem()).hashCode());
        n = 31 * n + (this.getExpected() == null ? 0 : ((Object)this.getExpected()).hashCode());
        n = 31 * n + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        n = 31 * n + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        n = 31 * n + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest putItemRequest = (PutItemRequest)object;
        if (putItemRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (putItemRequest.getTableName() != null && !putItemRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (putItemRequest.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        if (putItemRequest.getItem() != null && !((Object)putItemRequest.getItem()).equals(this.getItem())) {
            return false;
        }
        if (putItemRequest.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (putItemRequest.getExpected() != null && !((Object)putItemRequest.getExpected()).equals(this.getExpected())) {
            return false;
        }
        if (putItemRequest.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        if (putItemRequest.getReturnValues() != null && !putItemRequest.getReturnValues().equals(this.getReturnValues())) {
            return false;
        }
        if (putItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (putItemRequest.getReturnConsumedCapacity() != null && !putItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (putItemRequest.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        if (putItemRequest.getReturnItemCollectionMetrics() != null && !putItemRequest.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics())) {
            return false;
        }
        if (putItemRequest.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        return putItemRequest.getConditionalOperator() == null || putItemRequest.getConditionalOperator().equals(this.getConditionalOperator());
    }
}

