/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTableRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private ListWithAutoConstructFlag<LocalSecondaryIndex> localSecondaryIndexes;
    private ListWithAutoConstructFlag<GlobalSecondaryIndex> globalSecondaryIndexes;
    private ProvisionedThroughput provisionedThroughput;

    public CreateTableRequest() {
    }

    public CreateTableRequest(String string, List<KeySchemaElement> list) {
        this.setTableName(string);
        this.setKeySchema(list);
    }

    public CreateTableRequest(List<AttributeDefinition> list, String string, List<KeySchemaElement> list2, ProvisionedThroughput provisionedThroughput) {
        this.setAttributeDefinitions(list);
        this.setTableName(string);
        this.setKeySchema(list2);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> collection) {
        if (collection == null) {
            this.attributeDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributeDefinitions = listWithAutoConstructFlag;
    }

    public CreateTableRequest withAttributeDefinitions(AttributeDefinition ... attributeDefinitionArray) {
        if (this.getAttributeDefinitions() == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitionArray.length));
        }
        for (AttributeDefinition attributeDefinition : attributeDefinitionArray) {
            this.getAttributeDefinitions().add(attributeDefinition);
        }
        return this;
    }

    public CreateTableRequest withAttributeDefinitions(Collection<AttributeDefinition> collection) {
        if (collection == null) {
            this.attributeDefinitions = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributeDefinitions = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public CreateTableRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keySchema = listWithAutoConstructFlag;
    }

    public CreateTableRequest withKeySchema(KeySchemaElement ... keySchemaElementArray) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchemaElementArray.length));
        }
        for (KeySchemaElement keySchemaElement : keySchemaElementArray) {
            this.getKeySchema().add(keySchemaElement);
        }
        return this;
    }

    public CreateTableRequest withKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keySchema = listWithAutoConstructFlag;
        }
        return this;
    }

    public List<LocalSecondaryIndex> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex> collection) {
        if (collection == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.localSecondaryIndexes = listWithAutoConstructFlag;
    }

    public CreateTableRequest withLocalSecondaryIndexes(LocalSecondaryIndex ... localSecondaryIndexArray) {
        if (this.getLocalSecondaryIndexes() == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndex>(localSecondaryIndexArray.length));
        }
        for (LocalSecondaryIndex localSecondaryIndex : localSecondaryIndexArray) {
            this.getLocalSecondaryIndexes().add(localSecondaryIndex);
        }
        return this;
    }

    public CreateTableRequest withLocalSecondaryIndexes(Collection<LocalSecondaryIndex> collection) {
        if (collection == null) {
            this.localSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.localSecondaryIndexes = listWithAutoConstructFlag;
        }
        return this;
    }

    public List<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> collection) {
        if (collection == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.globalSecondaryIndexes = listWithAutoConstructFlag;
    }

    public CreateTableRequest withGlobalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexArray) {
        if (this.getGlobalSecondaryIndexes() == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndex>(globalSecondaryIndexArray.length));
        }
        for (GlobalSecondaryIndex globalSecondaryIndex : globalSecondaryIndexArray) {
            this.getGlobalSecondaryIndexes().add(globalSecondaryIndex);
        }
        return this;
    }

    public CreateTableRequest withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> collection) {
        if (collection == null) {
            this.globalSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.globalSecondaryIndexes = listWithAutoConstructFlag;
        }
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public CreateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getAttributeDefinitions() != null) {
            stringBuilder.append("AttributeDefinitions: " + this.getAttributeDefinitions() + ",");
        }
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKeySchema() != null) {
            stringBuilder.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            stringBuilder.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            stringBuilder.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            stringBuilder.append("ProvisionedThroughput: " + this.getProvisionedThroughput());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getAttributeDefinitions() == null ? 0 : ((Object)this.getAttributeDefinitions()).hashCode());
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        n = 31 * n + (this.getLocalSecondaryIndexes() == null ? 0 : ((Object)this.getLocalSecondaryIndexes()).hashCode());
        n = 31 * n + (this.getGlobalSecondaryIndexes() == null ? 0 : ((Object)this.getGlobalSecondaryIndexes()).hashCode());
        n = 31 * n + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest createTableRequest = (CreateTableRequest)object;
        if (createTableRequest.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (createTableRequest.getAttributeDefinitions() != null && !((Object)createTableRequest.getAttributeDefinitions()).equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (createTableRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (createTableRequest.getTableName() != null && !createTableRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (createTableRequest.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (createTableRequest.getKeySchema() != null && !((Object)createTableRequest.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (createTableRequest.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (createTableRequest.getLocalSecondaryIndexes() != null && !((Object)createTableRequest.getLocalSecondaryIndexes()).equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (createTableRequest.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        if (createTableRequest.getGlobalSecondaryIndexes() != null && !((Object)createTableRequest.getGlobalSecondaryIndexes()).equals(this.getGlobalSecondaryIndexes())) {
            return false;
        }
        if (createTableRequest.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        return createTableRequest.getProvisionedThroughput() == null || createTableRequest.getProvisionedThroughput().equals(this.getProvisionedThroughput());
    }
}

