/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonDynamoDBAsyncClient
extends AmazonDynamoDBClient
implements AmazonDynamoDBAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonDynamoDBAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonDynamoDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials aWSCredentials, ExecutorService executorService) {
        super(aWSCredentials);
        this.executorService = executorService;
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ExecutorService executorService) {
        this(aWSCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.scan(scanRequest);
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest, final AsyncHandler<ScanRequest, ScanResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                ScanResult scanResult;
                try {
                    scanResult = AmazonDynamoDBAsyncClient.this.scan(scanRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)scanRequest, (Object)scanResult);
                return scanResult;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult updateTableResult;
                try {
                    updateTableResult = AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateTableRequest, (Object)updateTableResult);
                return updateTableResult;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult deleteTableResult;
                try {
                    deleteTableResult = AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTableRequest, (Object)deleteTableResult);
                return deleteTableResult;
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest, final AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                BatchWriteItemResult batchWriteItemResult;
                try {
                    batchWriteItemResult = AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchWriteItemRequest, (Object)batchWriteItemResult);
                return batchWriteItemResult;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult describeTableResult;
                try {
                    describeTableResult = AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTableRequest, (Object)describeTableResult);
                return describeTableResult;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest, final AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                GetItemResult getItemResult;
                try {
                    getItemResult = AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getItemRequest, (Object)getItemResult);
                return getItemResult;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest, final AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                DeleteItemResult deleteItemResult;
                try {
                    deleteItemResult = AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteItemRequest, (Object)deleteItemResult);
                return deleteItemResult;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult createTableResult;
                try {
                    createTableResult = AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createTableRequest, (Object)createTableResult);
                return createTableResult;
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.query(queryRequest);
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult queryResult;
                try {
                    queryResult = AmazonDynamoDBAsyncClient.this.query(queryRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)queryRequest, (Object)queryResult);
                return queryResult;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest, final AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                PutItemResult putItemResult;
                try {
                    putItemResult = AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putItemRequest, (Object)putItemResult);
                return putItemResult;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult listTablesResult;
                try {
                    listTablesResult = AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTablesRequest, (Object)listTablesResult);
                return listTablesResult;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest, final AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                UpdateItemResult updateItemResult;
                try {
                    updateItemResult = AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateItemRequest, (Object)updateItemResult);
                return updateItemResult;
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                return AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest, final AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                BatchGetItemResult batchGetItemResult;
                try {
                    batchGetItemResult = AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchGetItemRequest, (Object)batchGetItemResult);
                return batchGetItemResult;
            }
        });
    }
}

