/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTableRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private ProvisionedThroughput provisionedThroughput;
    private ListWithAutoConstructFlag<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

    public UpdateTableRequest() {
    }

    public UpdateTableRequest(String string, ProvisionedThroughput provisionedThroughput) {
        this.setTableName(string);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public UpdateTableRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public UpdateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public List<GlobalSecondaryIndexUpdate> getGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> collection) {
        if (collection == null) {
            this.globalSecondaryIndexUpdates = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.globalSecondaryIndexUpdates = listWithAutoConstructFlag;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate ... globalSecondaryIndexUpdateArray) {
        if (this.getGlobalSecondaryIndexUpdates() == null) {
            this.setGlobalSecondaryIndexUpdates(new ArrayList<GlobalSecondaryIndexUpdate>(globalSecondaryIndexUpdateArray.length));
        }
        for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdate : globalSecondaryIndexUpdateArray) {
            this.getGlobalSecondaryIndexUpdates().add(globalSecondaryIndexUpdate);
        }
        return this;
    }

    public UpdateTableRequest withGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> collection) {
        if (collection == null) {
            this.globalSecondaryIndexUpdates = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.globalSecondaryIndexUpdates = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            stringBuilder.append("ProvisionedThroughput: " + this.getProvisionedThroughput() + ",");
        }
        if (this.getGlobalSecondaryIndexUpdates() != null) {
            stringBuilder.append("GlobalSecondaryIndexUpdates: " + this.getGlobalSecondaryIndexUpdates());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        n = 31 * n + (this.getGlobalSecondaryIndexUpdates() == null ? 0 : ((Object)this.getGlobalSecondaryIndexUpdates()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest updateTableRequest = (UpdateTableRequest)object;
        if (updateTableRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (updateTableRequest.getTableName() != null && !updateTableRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (updateTableRequest.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (updateTableRequest.getProvisionedThroughput() != null && !updateTableRequest.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (updateTableRequest.getGlobalSecondaryIndexUpdates() == null ^ this.getGlobalSecondaryIndexUpdates() == null) {
            return false;
        }
        return updateTableRequest.getGlobalSecondaryIndexUpdates() == null || ((Object)updateTableRequest.getGlobalSecondaryIndexUpdates()).equals(this.getGlobalSecondaryIndexUpdates());
    }
}

