/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Integer limit;
    private String select;
    private Map<String, Condition> scanFilter;
    private String conditionalOperator;
    private Map<String, AttributeValue> exclusiveStartKey;
    private String returnConsumedCapacity;
    private Integer totalSegments;
    private Integer segment;

    public ScanRequest() {
    }

    public ScanRequest(String string) {
        this.setTableName(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public ScanRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributesToGet = listWithAutoConstructFlag;
    }

    public ScanRequest withAttributesToGet(String ... stringArray) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getAttributesToGet().add(string);
        }
        return this;
    }

    public ScanRequest withAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributesToGet = listWithAutoConstructFlag;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer n) {
        this.limit = n;
    }

    public ScanRequest withLimit(Integer n) {
        this.limit = n;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String string) {
        this.select = string;
    }

    public ScanRequest withSelect(String string) {
        this.select = string;
        return this;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public ScanRequest withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public Map<String, Condition> getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> map) {
        this.scanFilter = map;
    }

    public ScanRequest withScanFilter(Map<String, Condition> map) {
        this.setScanFilter(map);
        return this;
    }

    public ScanRequest addScanFilterEntry(String string, Condition condition) {
        if (null == this.scanFilter) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        if (this.scanFilter.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.scanFilter.put(string, condition);
        return this;
    }

    public ScanRequest clearScanFilterEntries() {
        this.scanFilter = null;
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public ScanRequest withConditionalOperator(String string) {
        this.conditionalOperator = string;
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public ScanRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> map) {
        this.exclusiveStartKey = map;
    }

    public ScanRequest withExclusiveStartKey(Map<String, AttributeValue> map) {
        this.setExclusiveStartKey(map);
        return this;
    }

    public void setExclusiveStartKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        HashMap<String, AttributeValue> hashMap = new HashMap<String, AttributeValue>();
        if (entry == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        hashMap.put(entry.getKey(), entry.getValue());
        if (entry2 != null) {
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setExclusiveStartKey(hashMap);
    }

    public ScanRequest withExclusiveStartKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        this.setExclusiveStartKey(entry, entry2);
        return this;
    }

    public ScanRequest addExclusiveStartKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>();
        }
        if (this.exclusiveStartKey.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.exclusiveStartKey.put(string, attributeValue);
        return this;
    }

    public ScanRequest clearExclusiveStartKeyEntries() {
        this.exclusiveStartKey = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public ScanRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public ScanRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public Integer getTotalSegments() {
        return this.totalSegments;
    }

    public void setTotalSegments(Integer n) {
        this.totalSegments = n;
    }

    public ScanRequest withTotalSegments(Integer n) {
        this.totalSegments = n;
        return this;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public void setSegment(Integer n) {
        this.segment = n;
    }

    public ScanRequest withSegment(Integer n) {
        this.segment = n;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getAttributesToGet() != null) {
            stringBuilder.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.getLimit() != null) {
            stringBuilder.append("Limit: " + this.getLimit() + ",");
        }
        if (this.getSelect() != null) {
            stringBuilder.append("Select: " + this.getSelect() + ",");
        }
        if (this.getScanFilter() != null) {
            stringBuilder.append("ScanFilter: " + this.getScanFilter() + ",");
        }
        if (this.getConditionalOperator() != null) {
            stringBuilder.append("ConditionalOperator: " + this.getConditionalOperator() + ",");
        }
        if (this.getExclusiveStartKey() != null) {
            stringBuilder.append("ExclusiveStartKey: " + this.getExclusiveStartKey() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getTotalSegments() != null) {
            stringBuilder.append("TotalSegments: " + this.getTotalSegments() + ",");
        }
        if (this.getSegment() != null) {
            stringBuilder.append("Segment: " + this.getSegment());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        n = 31 * n + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        n = 31 * n + (this.getSelect() == null ? 0 : this.getSelect().hashCode());
        n = 31 * n + (this.getScanFilter() == null ? 0 : ((Object)this.getScanFilter()).hashCode());
        n = 31 * n + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        n = 31 * n + (this.getExclusiveStartKey() == null ? 0 : ((Object)this.getExclusiveStartKey()).hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        n = 31 * n + (this.getTotalSegments() == null ? 0 : this.getTotalSegments().hashCode());
        n = 31 * n + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ScanRequest)) {
            return false;
        }
        ScanRequest scanRequest = (ScanRequest)object;
        if (scanRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (scanRequest.getTableName() != null && !scanRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (scanRequest.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (scanRequest.getAttributesToGet() != null && !((Object)scanRequest.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (scanRequest.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (scanRequest.getLimit() != null && !scanRequest.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (scanRequest.getSelect() == null ^ this.getSelect() == null) {
            return false;
        }
        if (scanRequest.getSelect() != null && !scanRequest.getSelect().equals(this.getSelect())) {
            return false;
        }
        if (scanRequest.getScanFilter() == null ^ this.getScanFilter() == null) {
            return false;
        }
        if (scanRequest.getScanFilter() != null && !((Object)scanRequest.getScanFilter()).equals(this.getScanFilter())) {
            return false;
        }
        if (scanRequest.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (scanRequest.getConditionalOperator() != null && !scanRequest.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (scanRequest.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        if (scanRequest.getExclusiveStartKey() != null && !((Object)scanRequest.getExclusiveStartKey()).equals(this.getExclusiveStartKey())) {
            return false;
        }
        if (scanRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (scanRequest.getReturnConsumedCapacity() != null && !scanRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (scanRequest.getTotalSegments() == null ^ this.getTotalSegments() == null) {
            return false;
        }
        if (scanRequest.getTotalSegments() != null && !scanRequest.getTotalSegments().equals(this.getTotalSegments())) {
            return false;
        }
        if (scanRequest.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        return scanRequest.getSegment() == null || scanRequest.getSegment().equals(this.getSegment());
    }
}

