/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalSecondaryIndexDescription
implements Serializable {
    private String indexName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private Projection projection;
    private Long indexSizeBytes;
    private Long itemCount;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public LocalSecondaryIndexDescription withIndexName(String string) {
        this.indexName = string;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keySchema = listWithAutoConstructFlag;
    }

    public LocalSecondaryIndexDescription withKeySchema(KeySchemaElement ... keySchemaElementArray) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchemaElementArray.length));
        }
        for (KeySchemaElement keySchemaElement : keySchemaElementArray) {
            this.getKeySchema().add(keySchemaElement);
        }
        return this;
    }

    public LocalSecondaryIndexDescription withKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keySchema = listWithAutoConstructFlag;
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public LocalSecondaryIndexDescription withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public Long getIndexSizeBytes() {
        return this.indexSizeBytes;
    }

    public void setIndexSizeBytes(Long l) {
        this.indexSizeBytes = l;
    }

    public LocalSecondaryIndexDescription withIndexSizeBytes(Long l) {
        this.indexSizeBytes = l;
        return this;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long l) {
        this.itemCount = l;
    }

    public LocalSecondaryIndexDescription withItemCount(Long l) {
        this.itemCount = l;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIndexName() != null) {
            stringBuilder.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            stringBuilder.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            stringBuilder.append("Projection: " + this.getProjection() + ",");
        }
        if (this.getIndexSizeBytes() != null) {
            stringBuilder.append("IndexSizeBytes: " + this.getIndexSizeBytes() + ",");
        }
        if (this.getItemCount() != null) {
            stringBuilder.append("ItemCount: " + this.getItemCount());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        n = 31 * n + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        n = 31 * n + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        n = 31 * n + (this.getIndexSizeBytes() == null ? 0 : this.getIndexSizeBytes().hashCode());
        n = 31 * n + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LocalSecondaryIndexDescription)) {
            return false;
        }
        LocalSecondaryIndexDescription localSecondaryIndexDescription = (LocalSecondaryIndexDescription)object;
        if (localSecondaryIndexDescription.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (localSecondaryIndexDescription.getIndexName() != null && !localSecondaryIndexDescription.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (localSecondaryIndexDescription.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (localSecondaryIndexDescription.getKeySchema() != null && !((Object)localSecondaryIndexDescription.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (localSecondaryIndexDescription.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (localSecondaryIndexDescription.getProjection() != null && !localSecondaryIndexDescription.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (localSecondaryIndexDescription.getIndexSizeBytes() == null ^ this.getIndexSizeBytes() == null) {
            return false;
        }
        if (localSecondaryIndexDescription.getIndexSizeBytes() != null && !localSecondaryIndexDescription.getIndexSizeBytes().equals(this.getIndexSizeBytes())) {
            return false;
        }
        if (localSecondaryIndexDescription.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        return localSecondaryIndexDescription.getItemCount() == null || localSecondaryIndexDescription.getItemCount().equals(this.getItemCount());
    }
}

