/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalSecondaryIndex
implements Serializable {
    private String indexName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private Projection projection;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public LocalSecondaryIndex withIndexName(String string) {
        this.indexName = string;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keySchema = listWithAutoConstructFlag;
    }

    public LocalSecondaryIndex withKeySchema(KeySchemaElement ... keySchemaElementArray) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchemaElementArray.length));
        }
        for (KeySchemaElement keySchemaElement : keySchemaElementArray) {
            this.getKeySchema().add(keySchemaElement);
        }
        return this;
    }

    public LocalSecondaryIndex withKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keySchema = listWithAutoConstructFlag;
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public LocalSecondaryIndex withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIndexName() != null) {
            stringBuilder.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            stringBuilder.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            stringBuilder.append("Projection: " + this.getProjection());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        n = 31 * n + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        n = 31 * n + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LocalSecondaryIndex)) {
            return false;
        }
        LocalSecondaryIndex localSecondaryIndex = (LocalSecondaryIndex)object;
        if (localSecondaryIndex.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (localSecondaryIndex.getIndexName() != null && !localSecondaryIndex.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (localSecondaryIndex.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (localSecondaryIndex.getKeySchema() != null && !((Object)localSecondaryIndex.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (localSecondaryIndex.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        return localSecondaryIndex.getProjection() == null || localSecondaryIndex.getProjection().equals(this.getProjection());
    }
}

