/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.Capacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConsumedCapacity
implements Serializable {
    private String tableName;
    private Double capacityUnits;
    private Capacity table;
    private Map<String, Capacity> localSecondaryIndexes;
    private Map<String, Capacity> globalSecondaryIndexes;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public ConsumedCapacity withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Double getCapacityUnits() {
        return this.capacityUnits;
    }

    public void setCapacityUnits(Double d) {
        this.capacityUnits = d;
    }

    public ConsumedCapacity withCapacityUnits(Double d) {
        this.capacityUnits = d;
        return this;
    }

    public Capacity getTable() {
        return this.table;
    }

    public void setTable(Capacity capacity) {
        this.table = capacity;
    }

    public ConsumedCapacity withTable(Capacity capacity) {
        this.table = capacity;
        return this;
    }

    public Map<String, Capacity> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Map<String, Capacity> map) {
        this.localSecondaryIndexes = map;
    }

    public ConsumedCapacity withLocalSecondaryIndexes(Map<String, Capacity> map) {
        this.setLocalSecondaryIndexes(map);
        return this;
    }

    public ConsumedCapacity addLocalSecondaryIndexesEntry(String string, Capacity capacity) {
        if (null == this.localSecondaryIndexes) {
            this.localSecondaryIndexes = new HashMap<String, Capacity>();
        }
        if (this.localSecondaryIndexes.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.localSecondaryIndexes.put(string, capacity);
        return this;
    }

    public ConsumedCapacity clearLocalSecondaryIndexesEntries() {
        this.localSecondaryIndexes = null;
        return this;
    }

    public Map<String, Capacity> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Map<String, Capacity> map) {
        this.globalSecondaryIndexes = map;
    }

    public ConsumedCapacity withGlobalSecondaryIndexes(Map<String, Capacity> map) {
        this.setGlobalSecondaryIndexes(map);
        return this;
    }

    public ConsumedCapacity addGlobalSecondaryIndexesEntry(String string, Capacity capacity) {
        if (null == this.globalSecondaryIndexes) {
            this.globalSecondaryIndexes = new HashMap<String, Capacity>();
        }
        if (this.globalSecondaryIndexes.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.globalSecondaryIndexes.put(string, capacity);
        return this;
    }

    public ConsumedCapacity clearGlobalSecondaryIndexesEntries() {
        this.globalSecondaryIndexes = null;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getCapacityUnits() != null) {
            stringBuilder.append("CapacityUnits: " + this.getCapacityUnits() + ",");
        }
        if (this.getTable() != null) {
            stringBuilder.append("Table: " + this.getTable() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            stringBuilder.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            stringBuilder.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getCapacityUnits() == null ? 0 : this.getCapacityUnits().hashCode());
        n = 31 * n + (this.getTable() == null ? 0 : this.getTable().hashCode());
        n = 31 * n + (this.getLocalSecondaryIndexes() == null ? 0 : ((Object)this.getLocalSecondaryIndexes()).hashCode());
        n = 31 * n + (this.getGlobalSecondaryIndexes() == null ? 0 : ((Object)this.getGlobalSecondaryIndexes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConsumedCapacity)) {
            return false;
        }
        ConsumedCapacity consumedCapacity = (ConsumedCapacity)object;
        if (consumedCapacity.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (consumedCapacity.getTableName() != null && !consumedCapacity.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (consumedCapacity.getCapacityUnits() == null ^ this.getCapacityUnits() == null) {
            return false;
        }
        if (consumedCapacity.getCapacityUnits() != null && !consumedCapacity.getCapacityUnits().equals(this.getCapacityUnits())) {
            return false;
        }
        if (consumedCapacity.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (consumedCapacity.getTable() != null && !consumedCapacity.getTable().equals(this.getTable())) {
            return false;
        }
        if (consumedCapacity.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (consumedCapacity.getLocalSecondaryIndexes() != null && !((Object)consumedCapacity.getLocalSecondaryIndexes()).equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (consumedCapacity.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        return consumedCapacity.getGlobalSecondaryIndexes() == null || ((Object)consumedCapacity.getGlobalSecondaryIndexes()).equals(this.getGlobalSecondaryIndexes());
    }
}

