/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteItemResult
implements Serializable {
    private Map<String, List<WriteRequest>> unprocessedItems;
    private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private ListWithAutoConstructFlag<ConsumedCapacity> consumedCapacity;

    public Map<String, List<WriteRequest>> getUnprocessedItems() {
        return this.unprocessedItems;
    }

    public void setUnprocessedItems(Map<String, List<WriteRequest>> map) {
        this.unprocessedItems = map;
    }

    public BatchWriteItemResult withUnprocessedItems(Map<String, List<WriteRequest>> map) {
        this.setUnprocessedItems(map);
        return this;
    }

    public BatchWriteItemResult addUnprocessedItemsEntry(String string, List<WriteRequest> list) {
        if (null == this.unprocessedItems) {
            this.unprocessedItems = new HashMap<String, List<WriteRequest>>();
        }
        if (this.unprocessedItems.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.unprocessedItems.put(string, list);
        return this;
    }

    public BatchWriteItemResult clearUnprocessedItemsEntries() {
        this.unprocessedItems = null;
        return this;
    }

    public Map<String, List<ItemCollectionMetrics>> getItemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public void setItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> map) {
        this.itemCollectionMetrics = map;
    }

    public BatchWriteItemResult withItemCollectionMetrics(Map<String, List<ItemCollectionMetrics>> map) {
        this.setItemCollectionMetrics(map);
        return this;
    }

    public BatchWriteItemResult addItemCollectionMetricsEntry(String string, List<ItemCollectionMetrics> list) {
        if (null == this.itemCollectionMetrics) {
            this.itemCollectionMetrics = new HashMap<String, List<ItemCollectionMetrics>>();
        }
        if (this.itemCollectionMetrics.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.itemCollectionMetrics.put(string, list);
        return this;
    }

    public BatchWriteItemResult clearItemCollectionMetricsEntries() {
        this.itemCollectionMetrics = null;
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> collection) {
        if (collection == null) {
            this.consumedCapacity = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.consumedCapacity = listWithAutoConstructFlag;
    }

    public BatchWriteItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacityArray) {
        if (this.getConsumedCapacity() == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacityArray.length));
        }
        for (ConsumedCapacity consumedCapacity : consumedCapacityArray) {
            this.getConsumedCapacity().add(consumedCapacity);
        }
        return this;
    }

    public BatchWriteItemResult withConsumedCapacity(Collection<ConsumedCapacity> collection) {
        if (collection == null) {
            this.consumedCapacity = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.consumedCapacity = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getUnprocessedItems() != null) {
            stringBuilder.append("UnprocessedItems: " + this.getUnprocessedItems() + ",");
        }
        if (this.getItemCollectionMetrics() != null) {
            stringBuilder.append("ItemCollectionMetrics: " + this.getItemCollectionMetrics() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            stringBuilder.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getUnprocessedItems() == null ? 0 : ((Object)this.getUnprocessedItems()).hashCode());
        n = 31 * n + (this.getItemCollectionMetrics() == null ? 0 : ((Object)this.getItemCollectionMetrics()).hashCode());
        n = 31 * n + (this.getConsumedCapacity() == null ? 0 : ((Object)this.getConsumedCapacity()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchWriteItemResult)) {
            return false;
        }
        BatchWriteItemResult batchWriteItemResult = (BatchWriteItemResult)object;
        if (batchWriteItemResult.getUnprocessedItems() == null ^ this.getUnprocessedItems() == null) {
            return false;
        }
        if (batchWriteItemResult.getUnprocessedItems() != null && !((Object)batchWriteItemResult.getUnprocessedItems()).equals(this.getUnprocessedItems())) {
            return false;
        }
        if (batchWriteItemResult.getItemCollectionMetrics() == null ^ this.getItemCollectionMetrics() == null) {
            return false;
        }
        if (batchWriteItemResult.getItemCollectionMetrics() != null && !((Object)batchWriteItemResult.getItemCollectionMetrics()).equals(this.getItemCollectionMetrics())) {
            return false;
        }
        if (batchWriteItemResult.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return batchWriteItemResult.getConsumedCapacity() == null || ((Object)batchWriteItemResult.getConsumedCapacity()).equals(this.getConsumedCapacity());
    }
}

