/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetItemResult
implements Serializable {
    private Map<String, List<Map<String, AttributeValue>>> responses;
    private Map<String, KeysAndAttributes> unprocessedKeys;
    private ListWithAutoConstructFlag<ConsumedCapacity> consumedCapacity;

    public Map<String, List<Map<String, AttributeValue>>> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, List<Map<String, AttributeValue>>> map) {
        this.responses = map;
    }

    public BatchGetItemResult withResponses(Map<String, List<Map<String, AttributeValue>>> map) {
        this.setResponses(map);
        return this;
    }

    public BatchGetItemResult addResponsesEntry(String string, List<Map<String, AttributeValue>> list) {
        if (null == this.responses) {
            this.responses = new HashMap<String, List<Map<String, AttributeValue>>>();
        }
        if (this.responses.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.responses.put(string, list);
        return this;
    }

    public BatchGetItemResult clearResponsesEntries() {
        this.responses = null;
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public void setUnprocessedKeys(Map<String, KeysAndAttributes> map) {
        this.unprocessedKeys = map;
    }

    public BatchGetItemResult withUnprocessedKeys(Map<String, KeysAndAttributes> map) {
        this.setUnprocessedKeys(map);
        return this;
    }

    public BatchGetItemResult addUnprocessedKeysEntry(String string, KeysAndAttributes keysAndAttributes) {
        if (null == this.unprocessedKeys) {
            this.unprocessedKeys = new HashMap<String, KeysAndAttributes>();
        }
        if (this.unprocessedKeys.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.unprocessedKeys.put(string, keysAndAttributes);
        return this;
    }

    public BatchGetItemResult clearUnprocessedKeysEntries() {
        this.unprocessedKeys = null;
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> collection) {
        if (collection == null) {
            this.consumedCapacity = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.consumedCapacity = listWithAutoConstructFlag;
    }

    public BatchGetItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacityArray) {
        if (this.getConsumedCapacity() == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacityArray.length));
        }
        for (ConsumedCapacity consumedCapacity : consumedCapacityArray) {
            this.getConsumedCapacity().add(consumedCapacity);
        }
        return this;
    }

    public BatchGetItemResult withConsumedCapacity(Collection<ConsumedCapacity> collection) {
        if (collection == null) {
            this.consumedCapacity = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.consumedCapacity = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getResponses() != null) {
            stringBuilder.append("Responses: " + this.getResponses() + ",");
        }
        if (this.getUnprocessedKeys() != null) {
            stringBuilder.append("UnprocessedKeys: " + this.getUnprocessedKeys() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            stringBuilder.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getResponses() == null ? 0 : ((Object)this.getResponses()).hashCode());
        n = 31 * n + (this.getUnprocessedKeys() == null ? 0 : ((Object)this.getUnprocessedKeys()).hashCode());
        n = 31 * n + (this.getConsumedCapacity() == null ? 0 : ((Object)this.getConsumedCapacity()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchGetItemResult)) {
            return false;
        }
        BatchGetItemResult batchGetItemResult = (BatchGetItemResult)object;
        if (batchGetItemResult.getResponses() == null ^ this.getResponses() == null) {
            return false;
        }
        if (batchGetItemResult.getResponses() != null && !((Object)batchGetItemResult.getResponses()).equals(this.getResponses())) {
            return false;
        }
        if (batchGetItemResult.getUnprocessedKeys() == null ^ this.getUnprocessedKeys() == null) {
            return false;
        }
        if (batchGetItemResult.getUnprocessedKeys() != null && !((Object)batchGetItemResult.getUnprocessedKeys()).equals(this.getUnprocessedKeys())) {
            return false;
        }
        if (batchGetItemResult.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return batchGetItemResult.getConsumedCapacity() == null || ((Object)batchGetItemResult.getConsumedCapacity()).equals(this.getConsumedCapacity());
    }
}

