/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.json.AwsJsonWriter;
import java.nio.ByteBuffer;
import java.util.Map;

public class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    public void marshall(AttributeValue attributeValue, AwsJsonWriter jsonWriter) {
        if (attributeValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ListWithAutoConstructFlag lList;
            ListWithAutoConstructFlag bSList;
            ListWithAutoConstructFlag nSList;
            ListWithAutoConstructFlag sSList;
            jsonWriter.beginObject();
            if (attributeValue.getS() != null) {
                jsonWriter.name("S").value(attributeValue.getS());
            }
            if (attributeValue.getN() != null) {
                jsonWriter.name("N").value(attributeValue.getN());
            }
            if (attributeValue.getB() != null) {
                jsonWriter.name("B").value(attributeValue.getB());
            }
            if (!((sSList = (ListWithAutoConstructFlag)attributeValue.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                jsonWriter.name("SS");
                jsonWriter.beginArray();
                for (String sSListValue : sSList) {
                    if (sSListValue == null) continue;
                    jsonWriter.value(sSListValue);
                }
                jsonWriter.endArray();
            }
            if (!((nSList = (ListWithAutoConstructFlag)attributeValue.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                jsonWriter.name("NS");
                jsonWriter.beginArray();
                for (String nSListValue : nSList) {
                    if (nSListValue == null) continue;
                    jsonWriter.value(nSListValue);
                }
                jsonWriter.endArray();
            }
            if (!((bSList = (ListWithAutoConstructFlag)attributeValue.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                jsonWriter.name("BS");
                jsonWriter.beginArray();
                for (ByteBuffer bSListValue : bSList) {
                    if (bSListValue == null) continue;
                    jsonWriter.value(bSListValue);
                }
                jsonWriter.endArray();
            }
            if (attributeValue.getM() != null) {
                jsonWriter.name("M");
                jsonWriter.beginObject();
                for (Map.Entry<String, AttributeValue> mListValue : attributeValue.getM().entrySet()) {
                    if (mListValue.getValue() == null) continue;
                    jsonWriter.name(mListValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(mListValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (!((lList = (ListWithAutoConstructFlag)attributeValue.getL()) == null || lList.isAutoConstruct() && lList.isEmpty())) {
                jsonWriter.name("L");
                jsonWriter.beginArray();
                for (AttributeValue lListValue : lList) {
                    if (lListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(lListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (attributeValue.isNULL() != null) {
                jsonWriter.name("NULL").value(attributeValue.isNULL().booleanValue());
            }
            if (attributeValue.isBOOL() != null) {
                jsonWriter.name("BOOL").value(attributeValue.isBOOL().booleanValue());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

