/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.json.AwsJsonFactory;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.AwsJsonToken;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.GsonFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    private static final AwsJsonFactory FACTORY = new GsonFactory();

    @Deprecated
    public static void setJsonEngine(JsonEngine jsonEngine) {
    }

    @Deprecated
    static void setJsonEngine(AwsJsonFactory awsJsonFactory) {
    }

    public static AwsJsonReader getJsonReader(Reader in) {
        return FACTORY.getJsonReader(in);
    }

    public static AwsJsonWriter getJsonWriter(Writer out) {
        return FACTORY.getJsonWriter(out);
    }

    public static Map<String, String> jsonToMap(Reader in) {
        AwsJsonReader reader = JsonUtils.getJsonReader(in);
        try {
            if (reader.peek() == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (reader.isContainer()) {
                    reader.skipValue();
                    continue;
                }
                map.put(key, reader.nextString());
            }
            reader.endObject();
            reader.close();
            return Collections.unmodifiableMap(map);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to parse JSON String.", e);
        }
    }

    public static Map<String, String> jsonToMap(String json) {
        if (json == null || json.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return JsonUtils.jsonToMap(new StringReader(json));
    }

    public static Map<String, String> jsonToStringMapWithList(Reader in) {
        AwsJsonReader reader = JsonUtils.getJsonReader(in);
        try {
            if (reader.peek() == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (reader.isContainer()) {
                    if (AwsJsonToken.BEGIN_ARRAY.equals((Object)reader.peek())) {
                        StringWriter out = new StringWriter();
                        AwsJsonWriter writer = JsonUtils.getJsonWriter(out);
                        reader.beginArray();
                        writer.beginArray();
                        try {
                            while (!AwsJsonToken.END_ARRAY.equals((Object)reader.peek())) {
                                AwsJsonToken nextToken = reader.peek();
                                if (AwsJsonToken.BEGIN_OBJECT.equals((Object)nextToken)) {
                                    reader.beginObject();
                                    writer.beginObject();
                                    continue;
                                }
                                if (AwsJsonToken.FIELD_NAME.equals((Object)nextToken)) {
                                    String name = reader.nextName();
                                    if (AwsJsonToken.BEGIN_ARRAY.equals((Object)reader.peek())) continue;
                                    writer.name(name);
                                    continue;
                                }
                                if (AwsJsonToken.END_OBJECT.equals((Object)nextToken)) {
                                    reader.endObject();
                                    writer.endObject();
                                    continue;
                                }
                                if (AwsJsonToken.END_ARRAY.equals((Object)nextToken)) {
                                    reader.endArray();
                                    writer.endArray();
                                    continue;
                                }
                                if (AwsJsonToken.VALUE_STRING.equals((Object)nextToken) || AwsJsonToken.VALUE_NUMBER.equals((Object)nextToken) || AwsJsonToken.VALUE_NULL.equals((Object)nextToken) || AwsJsonToken.VALUE_BOOLEAN.equals((Object)nextToken)) {
                                    String value = reader.nextString();
                                    writer.value(value);
                                    continue;
                                }
                                reader.skipValue();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        reader.endArray();
                        writer.endArray();
                        writer.flush();
                        writer.close();
                        map.put(key, out.toString());
                        continue;
                    }
                    reader.skipValue();
                    continue;
                }
                map.put(key, reader.nextString());
            }
            reader.endObject();
            reader.close();
            return Collections.unmodifiableMap(map);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to parse JSON String.", e);
        }
    }

    public static String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        try {
            StringWriter out = new StringWriter();
            AwsJsonWriter writer = JsonUtils.getJsonWriter(out);
            writer.beginObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                writer.name(entry.getKey()).value(entry.getValue());
            }
            writer.endObject();
            writer.close();
            return out.toString();
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to serialize to JSON String.", e);
        }
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    public static enum JsonEngine {
        Gson,
        Jackson;

    }
}

