/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;

public class AndroidLog
implements Log {
    private final String tag;
    private LogFactory.Level level = null;

    public AndroidLog(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean isDebugEnabled() {
        return android.util.Log.isLoggable((String)this.tag, (int)3) && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue());
    }

    @Override
    public boolean isErrorEnabled() {
        return android.util.Log.isLoggable((String)this.tag, (int)6) && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue());
    }

    @Override
    public boolean isInfoEnabled() {
        return android.util.Log.isLoggable((String)this.tag, (int)4) && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue());
    }

    @Override
    public boolean isTraceEnabled() {
        return android.util.Log.isLoggable((String)this.tag, (int)2) && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue());
    }

    @Override
    public boolean isWarnEnabled() {
        return android.util.Log.isLoggable((String)this.tag, (int)5) && (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue());
    }

    @Override
    public void trace(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue()) {
            android.util.Log.v((String)this.tag, (String)message.toString());
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue()) {
            android.util.Log.v((String)this.tag, (String)message.toString(), (Throwable)t);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue()) {
            android.util.Log.d((String)this.tag, (String)message.toString());
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue()) {
            android.util.Log.d((String)this.tag, (String)message.toString(), (Throwable)t);
        }
    }

    @Override
    public void info(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue()) {
            android.util.Log.i((String)this.tag, (String)message.toString());
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue()) {
            android.util.Log.i((String)this.tag, (String)message.toString(), (Throwable)t);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue()) {
            android.util.Log.w((String)this.tag, (String)message.toString());
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue()) {
            android.util.Log.w((String)this.tag, (String)message.toString(), (Throwable)t);
        }
    }

    @Override
    public void error(Object message) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue()) {
            android.util.Log.e((String)this.tag, (String)message.toString());
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue()) {
            android.util.Log.e((String)this.tag, (String)message.toString(), (Throwable)t);
        }
    }

    @Override
    public void setLevel(LogFactory.Level level) {
        this.level = level;
    }

    private LogFactory.Level getLevel() {
        if (this.level != null) {
            return this.level;
        }
        return LogFactory.getLevel();
    }
}

