/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ConnectionManagerFactory;
import com.amazonaws.http.impl.client.HttpRequestNoRetryHandler;
import com.amazonaws.http.impl.client.SdkHttpClient;
import java.net.InetAddress;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

class HttpClientFactory {
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;

    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClientParams, (boolean)true);
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        ThreadSafeClientConnManager connectionManager = ConnectionManagerFactory.createThreadSafeClientConnManager(config, (HttpParams)httpClientParams);
        SdkHttpClient httpClient = new SdkHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpClientParams);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)HttpRequestNoRetryHandler.Singleton);
        httpClient.setRedirectHandler((RedirectHandler)new LocationHeaderNotRequiredRedirectHandler());
        if (config.getLocalAddress() != null) {
            ConnRouteParams.setLocalAddress((HttpParams)httpClientParams, (InetAddress)config.getLocalAddress());
        }
        Scheme http = new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80);
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        sslSocketFactory.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        Scheme https = new Scheme("https", (SocketFactory)sslSocketFactory, 443);
        SchemeRegistry sr = connectionManager.getSchemeRegistry();
        sr.register(http);
        sr.register(https);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            AmazonHttpClient.log.info("Configuring Proxy. Proxy Host: " + proxyHost + " Proxy Port: " + proxyPort);
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        return httpClient;
    }

    private static final class LocationHeaderNotRequiredRedirectHandler
    extends DefaultRedirectHandler {
        private LocationHeaderNotRequiredRedirectHandler() {
        }

        public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
            int statusCode = response.getStatusLine().getStatusCode();
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null && statusCode == 301) {
                return false;
            }
            return super.isRedirectRequested(response, context);
        }
    }
}

