/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.Map;

public class UnlinkIdentityRequestMarshaller
implements Marshaller<Request<UnlinkIdentityRequest>, UnlinkIdentityRequest> {
    @Override
    public Request<UnlinkIdentityRequest> marshall(UnlinkIdentityRequest unlinkIdentityRequest) {
        if (unlinkIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UnlinkIdentityRequest> request = new DefaultRequest<UnlinkIdentityRequest>(unlinkIdentityRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.UnlinkIdentity";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag loginsToRemoveList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (unlinkIdentityRequest.getIdentityId() != null) {
                jsonWriter.name("IdentityId").value(unlinkIdentityRequest.getIdentityId());
            }
            if (unlinkIdentityRequest.getLogins() != null) {
                jsonWriter.name("Logins");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> loginsListValue : unlinkIdentityRequest.getLogins().entrySet()) {
                    if (loginsListValue.getValue() == null) continue;
                    jsonWriter.name(loginsListValue.getKey());
                    jsonWriter.value(loginsListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((loginsToRemoveList = (ListWithAutoConstructFlag)unlinkIdentityRequest.getLoginsToRemove()) == null || loginsToRemoveList.isAutoConstruct() && loginsToRemoveList.isEmpty())) {
                jsonWriter.name("LoginsToRemove");
                jsonWriter.beginArray();
                for (String loginsToRemoveListValue : loginsToRemoveList) {
                    if (loginsToRemoveListValue == null) continue;
                    jsonWriter.value(loginsToRemoveListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

