/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.util.VersionInfoUtils;
import java.util.Date;
import java.util.Map;

public class CognitoCachingCredentialsProvider
extends CognitoCredentialsProvider {
    private final String DEFAULT_SHAREDPREFERENCES_NAME = "com.amazonaws.android.auth";
    private static final String USER_AGENT = CognitoCachingCredentialsProvider.class.getName() + "/" + VersionInfoUtils.getVersion();
    private final SharedPreferences prefs;
    private String identityId;
    private static final String ID_KEY = "identityId";
    private static final String AK_KEY = "accessKey";
    private static final String SK_KEY = "secretKey";
    private static final String ST_KEY = "sessionToken";
    private static final String EXP_KEY = "expirationDate";
    boolean needIdentityRefresh = false;
    private static final String TAG = "CognitoCachingCredentialsProvider";
    private final IdentityChangedListener listener = new IdentityChangedListener(){

        @Override
        public void identityChanged(String oldIdentityId, String newIdentityId) {
            Log.d((String)CognitoCachingCredentialsProvider.TAG, (String)"Identity id is changed");
            CognitoCachingCredentialsProvider.this.saveIdentityId(newIdentityId);
        }
    };

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, String identityPoolId, Regions region) {
        super(identityPoolId, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, String identityPoolId, Regions region, ClientConfiguration clientConfiguration) {
        super(identityPoolId, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, String accountId, String identityPoolId, String unauthArn, String authArn, AmazonCognitoIdentityClient cibClient, AWSSecurityTokenService stsClient) {
        super(accountId, identityPoolId, unauthArn, authArn, cibClient, stsClient);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthArn, String authArn) {
        super(provider, unauthArn, authArn);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, String unauthArn, String authArn, AWSSecurityTokenService stsClient) {
        super(provider, unauthArn, authArn, stsClient);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, Regions region) {
        super(provider, region);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(Context context, AWSCognitoIdentityProvider provider, Regions region, ClientConfiguration clientConfiguration) {
        super(provider, region, clientConfiguration);
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.prefs = context.getSharedPreferences("com.amazonaws.android.auth", 0);
        this.initialize();
    }

    private void initialize() {
        this.checkUpgrade();
        this.identityId = this.getCachedIdentityId();
        this.loadCachedCredentials();
        this.registerIdentityChangedListener(this.listener);
    }

    @Override
    public String getIdentityId() {
        if (this.needIdentityRefresh) {
            this.needIdentityRefresh = false;
            this.refresh();
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        this.identityId = this.getCachedIdentityId();
        if (this.identityId == null) {
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        return this.identityId;
    }

    @Override
    public synchronized AWSSessionCredentials getCredentials() {
        if (this.sessionCredentials == null) {
            this.loadCachedCredentials();
        }
        if (!this.needsNewSession()) {
            return this.sessionCredentials;
        }
        try {
            super.getCredentials();
        }
        catch (NotAuthorizedException e) {
            Log.e((String)TAG, (String)"Failure to get credentials", (Throwable)e);
            if (this.getLogins() != null) {
                this.clear();
                super.getCredentials();
            }
            throw e;
        }
        this.saveCredentials(this.sessionCredentials, this.getSessionCredentitalsExpiration().getTime());
        return this.sessionCredentials;
    }

    @Override
    public void setLogins(Map<String, String> logins) {
        super.setLogins(logins);
        this.needIdentityRefresh = true;
        this.clearCredentials();
    }

    @Override
    public void clear() {
        super.clear();
        this.prefs.edit().clear().apply();
    }

    @Override
    public void clearCredentials() {
        super.clearCredentials();
        Log.d((String)TAG, (String)"Clearing credentials from SharedPreferences");
        if (this.sessionCredentials != null) {
            this.prefs.edit().remove(this.namespace(AK_KEY)).remove(this.namespace(SK_KEY)).remove(this.namespace(ST_KEY)).remove(this.namespace(EXP_KEY)).apply();
        }
    }

    public String getCachedIdentityId() {
        String cachedIdentityId = this.prefs.getString(this.namespace(ID_KEY), null);
        if (cachedIdentityId != null && this.identityId == null) {
            super.setIdentityId(cachedIdentityId);
        }
        return cachedIdentityId;
    }

    private void loadCachedCredentials() {
        Log.d((String)TAG, (String)"Loading credentials from SharedPreferences");
        this.sessionCredentialsExpiration = new Date(this.prefs.getLong(this.namespace(EXP_KEY), 0L));
        boolean bl = this.prefs.contains(this.namespace(AK_KEY));
        boolean bl2 = this.prefs.contains(this.namespace(SK_KEY));
        boolean bl3 = this.prefs.contains(this.namespace(ST_KEY));
        if (!(bl && bl2 && bl3)) {
            Log.d((String)TAG, (String)"No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        String string = this.prefs.getString(this.namespace(AK_KEY), null);
        String string2 = this.prefs.getString(this.namespace(SK_KEY), null);
        String string3 = this.prefs.getString(this.namespace(ST_KEY), null);
        this.sessionCredentials = new BasicSessionCredentials(string, string2, string3);
    }

    private void saveCredentials(AWSSessionCredentials aWSSessionCredentials, long l) {
        Log.d((String)TAG, (String)"Saving credentials to SharedPreferences");
        if (aWSSessionCredentials != null) {
            this.prefs.edit().putString(this.namespace(AK_KEY), aWSSessionCredentials.getAWSAccessKeyId()).putString(this.namespace(SK_KEY), aWSSessionCredentials.getAWSSecretKey()).putString(this.namespace(ST_KEY), aWSSessionCredentials.getSessionToken()).putLong(this.namespace(EXP_KEY), l).apply();
        }
    }

    private void saveIdentityId(String string) {
        Log.d((String)TAG, (String)"Saving identity id to SharedPreferences");
        this.identityId = string;
        this.prefs.edit().putString(this.namespace(ID_KEY), string).apply();
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }

    private void checkUpgrade() {
        if (this.prefs.contains(ID_KEY)) {
            Log.i((String)TAG, (String)"Identity id without namespace is detected. It will be saved under new namespace.");
            String string = this.prefs.getString(ID_KEY, null);
            this.prefs.edit().clear().putString(this.namespace(ID_KEY), string).apply();
        }
    }

    private String namespace(String string) {
        return this.getIdentityPoolId() + "." + string;
    }
}

