/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.params;

import com.amazonaws.org.apache.http.params.HttpParams;

public abstract class AbstractHttpParams
implements HttpParams {
    protected AbstractHttpParams() {
    }

    public int getIntParameter(String name, int defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Integer)param;
    }

    public HttpParams setIntParameter(String name, int value) {
        this.setParameter(name, new Integer(value));
        return this;
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        Object param = this.getParameter(name);
        if (param == null) {
            return defaultValue;
        }
        return (Boolean)param;
    }

    public HttpParams setBooleanParameter(String name, boolean value) {
        this.setParameter(name, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public boolean isParameterTrue(String name) {
        return this.getBooleanParameter(name, false);
    }

    public boolean isParameterFalse(String name) {
        return !this.getBooleanParameter(name, false);
    }
}

