/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.org.apache.commons.codec.binary.Base64;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.NamespaceRemovingInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XpathUtils {
    private static DateUtils dateUtils = new DateUtils();
    private static Log log = LogFactory.getLog(XpathUtils.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document documentFrom(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        inputStream = new NamespaceRemovingInputStream(inputStream);
        Document document = factory.newDocumentBuilder().parse(inputStream);
        inputStream.close();
        return document;
    }

    public static Document documentFrom(String string) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(new ByteArrayInputStream(string.getBytes()));
    }

    public static Document documentFrom(URL uRL) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(uRL.openStream());
    }

    public static Double asDouble(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Double.valueOf(string2);
    }

    public static String asString(String string, Node node) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(string, node);
    }

    public static Integer asInteger(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Integer.valueOf(string2);
    }

    public static Boolean asBoolean(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Boolean.valueOf(string2);
    }

    public static Float asFloat(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Float.valueOf(string2);
    }

    public static Long asLong(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Long.valueOf(string2);
    }

    public static Byte asByte(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        return XpathUtils.isEmptyString(string2) ? null : Byte.valueOf(string2);
    }

    public static Date asDate(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        if (XpathUtils.isEmptyString(string2)) {
            return null;
        }
        return dateUtils.parseIso8601Date(string2);
    }

    public static ByteBuffer asByteBuffer(String string, Node node) throws XPathExpressionException {
        String string2 = XpathUtils.evaluateAsString(string, node);
        if (XpathUtils.isEmptyString(string2)) {
            return null;
        }
        if (!XpathUtils.isEmpty(node)) {
            try {
                byte[] byArray = string2.getBytes("UTF-8");
                byte[] byArray2 = Base64.decodeBase64(byArray);
                return ByteBuffer.wrap(byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AmazonClientException("Unable to unmarshall XML data into a ByteBuffer", unsupportedEncodingException);
            }
        }
        return null;
    }

    public static boolean isEmpty(Node node) {
        return node == null;
    }

    public static int nodeLength(NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    private static String evaluateAsString(String string, Node node) throws XPathExpressionException {
        if (XpathUtils.isEmpty(node)) {
            return null;
        }
        String string2 = XpathUtils.evaluateXPath(node, string);
        if (string2 == null) {
            return null;
        }
        return string2.trim();
    }

    public static Node asNode(String string, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return XpathUtils.findXPathNode(node, string);
    }

    public static NodeList asNodeList(String string, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return XpathUtils.findXPathNodeList(node, string);
    }

    private static boolean isEmptyString(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().equals("");
    }

    private static String evaluateXPath(Node node, String string) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf("/", n);
            String string2 = null;
            string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            node = XpathUtils.findChildNodeWithName(node, string2);
            if (n2 == -1) break;
            n = n2 + 1;
        }
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private static Node findXPathNode(Node node, String string) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf("/", n);
            String string2 = null;
            string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            node = XpathUtils.findChildNodeWithName(node, string2);
            if (n2 == -1) break;
            n = n2 + 1;
        }
        return node;
    }

    private static NodeList findXPathNodeList(Node node, String string) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf("/", n);
            String string2 = null;
            string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
            node = XpathUtils.findChildNodeWithName(node, string2);
            if (n2 == -1) break;
            n = n2 + 1;
        }
        return node.getChildNodes();
    }

    private static Node findChildNodeWithName(Node node, String string) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equals(string)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(string)) continue;
            return nodeList.item(i);
        }
        return null;
    }
}

