/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.AbstractBase32Codec;
import com.amazonaws.util.CodecUtils;

class Base32Codec
extends AbstractBase32Codec {
    private static final int OFFSET_OF_2 = 24;

    private static byte[] alphabets() {
        return CodecUtils.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    }

    Base32Codec() {
        super(Base32Codec.alphabets());
    }

    @Override
    protected int pos(byte by) {
        byte by2 = LazyHolder.DECODED[by];
        if (by2 > -1) {
            return by2;
        }
        throw new IllegalArgumentException("Invalid base 32 character: '" + (char)by + "'");
    }

    private static class LazyHolder {
        private static final byte[] DECODED = LazyHolder.decodeTable();

        private LazyHolder() {
        }

        private static byte[] decodeTable() {
            byte[] byArray = new byte[123];
            for (int i = 0; i <= 122; ++i) {
                byArray[i] = i >= 65 && i <= 90 ? (int)(i - 65) : (i >= 50 && i <= 55 ? (int)(i - 24) : (i >= 97 && i <= 122 ? (int)(i - 97) : -1));
            }
            return byArray;
        }
    }
}

