/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegionMetadataParser {
    private static final String REGION_TAG = "Region";
    private static final String REGION_ID_TAG = "Name";
    private static final String DOMAIN_TAG = "Domain";
    private static final String ENDPOINT_TAG = "Endpoint";
    private static final String SERVICE_TAG = "ServiceName";
    private static final String HTTP_TAG = "Http";
    private static final String HTTPS_TAG = "Https";
    private static final String HOSTNAME_TAG = "Hostname";

    public static RegionMetadata parse(InputStream inputStream) throws IOException {
        return new RegionMetadata(RegionMetadataParser.internalParse(inputStream, false));
    }

    @Deprecated
    public RegionMetadataParser() {
    }

    @Deprecated
    public List<Region> parseRegionMetadata(InputStream inputStream) throws IOException {
        return RegionMetadataParser.internalParse(inputStream, false);
    }

    @Deprecated
    public List<Region> parseRegionMetadata(InputStream inputStream, boolean bl) throws IOException {
        return RegionMetadataParser.internalParse(inputStream, bl);
    }

    private static List<Region> internalParse(InputStream inputStream, boolean bl) throws IOException {
        Document document;
        Object object;
        Object object2;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unable to parse region metadata file: " + exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        object2 = document.getElementsByTagName(REGION_TAG);
        object = new ArrayList();
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node = object2.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            object.add(RegionMetadataParser.parseRegionElement(element, bl));
        }
        return object;
    }

    private static Region parseRegionElement(Element element, boolean bl) {
        String string = RegionMetadataParser.getChildElementValue(REGION_ID_TAG, element);
        String string2 = RegionMetadataParser.getChildElementValue(DOMAIN_TAG, element);
        Region region = new Region(string, string2);
        NodeList nodeList = element.getElementsByTagName(ENDPOINT_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            RegionMetadataParser.addRegionEndpoint(region, (Element)nodeList.item(i), bl);
        }
        return region;
    }

    private static void addRegionEndpoint(Region region, Element element, boolean bl) {
        String string = RegionMetadataParser.getChildElementValue(SERVICE_TAG, element);
        String string2 = RegionMetadataParser.getChildElementValue(HOSTNAME_TAG, element);
        String string3 = RegionMetadataParser.getChildElementValue(HTTP_TAG, element);
        String string4 = RegionMetadataParser.getChildElementValue(HTTPS_TAG, element);
        if (bl && !RegionMetadataParser.verifyLegacyEndpoint(string2)) {
            throw new IllegalStateException("Invalid service endpoint (" + string2 + ") is detected.");
        }
        region.getServiceEndpoints().put(string, string2);
        region.getHttpSupport().put(string, "true".equals(string3));
        region.getHttpsSupport().put(string, "true".equals(string4));
    }

    private static String getChildElementValue(String string, Element element) {
        Node node = element.getElementsByTagName(string).item(0);
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = nodeList.item(0);
        return node2.getNodeValue();
    }

    private static boolean verifyLegacyEndpoint(String string) {
        return string.endsWith(".amazonaws.com");
    }
}

