/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.field;

import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.DurationFieldType;
import com.amazonaws.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public final class MillisDurationField
extends DurationField
implements Serializable {
    public static final DurationField INSTANCE = new MillisDurationField();

    private MillisDurationField() {
    }

    public DurationFieldType getType() {
        return DurationFieldType.millis();
    }

    public boolean isSupported() {
        return true;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return 1L;
    }

    public long add(long l, int n) {
        return FieldUtils.safeAdd(l, (long)n);
    }

    public long add(long l, long l2) {
        return FieldUtils.safeAdd(l, l2);
    }

    public int compareTo(DurationField durationField) {
        long l = durationField.getUnitMillis();
        long l2 = this.getUnitMillis();
        if (l2 == l) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof MillisDurationField) {
            return this.getUnitMillis() == ((MillisDurationField)object).getUnitMillis();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getUnitMillis();
    }

    public String toString() {
        return "DurationField[millis]";
    }
}

