/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.pool;

import com.amazonaws.org.apache.http.concurrent.FutureCallback;
import com.amazonaws.org.apache.http.pool.ConnFactory;
import com.amazonaws.org.apache.http.pool.ConnPoolControl;
import com.amazonaws.org.apache.http.pool.PoolEntry;
import com.amazonaws.org.apache.http.pool.PoolEntryFuture;
import com.amazonaws.org.apache.http.pool.PoolStats;
import com.amazonaws.org.apache.http.pool.RouteSpecificPool;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPoolControl<T> {
    private final Lock lock;
    private final ConnFactory<T, C> connFactory;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<PoolEntryFuture<E>> pending;
    private final Map<T, Integer> maxPerRoute;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    public AbstractConnPool(ConnFactory<T, C> connFactory, int defaultMaxPerRoute, int maxTotal) {
        if (connFactory == null) {
            throw new IllegalArgumentException("Connection factory may not null");
        }
        if (defaultMaxPerRoute <= 0) {
            throw new IllegalArgumentException("Max per route value may not be negative or zero");
        }
        if (maxTotal <= 0) {
            throw new IllegalArgumentException("Max total value may not be negative or zero");
        }
        this.lock = new ReentrantLock();
        this.connFactory = connFactory;
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.defaultMaxPerRoute = defaultMaxPerRoute;
        this.maxTotal = maxTotal;
    }

    protected abstract E createEntry(T var1, C var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (PoolEntry poolEntry : this.available) {
                poolEntry.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.available.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, C, E> getPool(final T route) {
        RouteSpecificPool pool = this.routeToPool.get(route);
        if (pool == null) {
            pool = new RouteSpecificPool<T, C, E>(route){

                @Override
                protected E createEntry(C conn) {
                    return AbstractConnPool.this.createEntry(route, conn);
                }
            };
            this.routeToPool.put(route, pool);
        }
        return pool;
    }

    public Future<E> lease(final T route, final Object state, FutureCallback<E> callback) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        if (this.isShutDown) {
            throw new IllegalStateException("Connection pool shut down");
        }
        return new PoolEntryFuture<E>(this.lock, callback){

            @Override
            public E getPoolEntry(long timeout, TimeUnit tunit) throws InterruptedException, TimeoutException, IOException {
                return AbstractConnPool.this.getPoolEntryBlocking(route, state, timeout, tunit, this);
            }
        };
    }

    public Future<E> lease(T route, Object state) {
        return this.lease(route, state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getPoolEntryBlocking(T t, Object object, long l, TimeUnit timeUnit, PoolEntryFuture<E> poolEntryFuture) throws IOException, InterruptedException, TimeoutException {
        Date date = null;
        if (l > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l));
        }
        this.lock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getPool(t);
            PoolEntry poolEntry = null;
            while (poolEntry == null) {
                int n;
                int n2;
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down");
                }
                while ((poolEntry = (PoolEntry)routeSpecificPool.getFree(object)) != null && (poolEntry.isClosed() || poolEntry.isExpired(System.currentTimeMillis()))) {
                    poolEntry.close();
                    this.available.remove(poolEntry);
                    routeSpecificPool.free(poolEntry, false);
                }
                if (poolEntry != null) {
                    this.available.remove(poolEntry);
                    this.leased.add(poolEntry);
                    PoolEntry poolEntry2 = poolEntry;
                    return (E)poolEntry2;
                }
                int n3 = this.getMax(t);
                int n4 = Math.max(0, routeSpecificPool.getAllocatedCount() + 1 - n3);
                if (n4 > 0) {
                    E e;
                    for (n2 = 0; n2 < n4 && (e = routeSpecificPool.getLastUsed()) != null; ++n2) {
                        ((PoolEntry)e).close();
                        this.available.remove(e);
                        routeSpecificPool.remove(e);
                    }
                }
                if (routeSpecificPool.getAllocatedCount() < n3 && (n = Math.max(this.maxTotal - (n2 = this.leased.size()), 0)) > 0) {
                    Object object2;
                    Object object3;
                    int n5 = this.available.size();
                    if (n5 > n - 1 && !this.available.isEmpty()) {
                        object3 = (PoolEntry)this.available.removeFirst();
                        ((PoolEntry)object3).close();
                        object2 = this.getPool(((PoolEntry)object3).getRoute());
                        ((RouteSpecificPool)object2).remove(object3);
                    }
                    object3 = this.connFactory.create(t);
                    poolEntry = routeSpecificPool.add(object3);
                    this.leased.add(poolEntry);
                    object2 = poolEntry;
                    return (E)object2;
                }
                n2 = 0;
                try {
                    routeSpecificPool.queue(poolEntryFuture);
                    this.pending.add(poolEntryFuture);
                    n2 = poolEntryFuture.await(date) ? 1 : 0;
                }
                finally {
                    routeSpecificPool.unqueue(poolEntryFuture);
                    this.pending.remove(poolEntryFuture);
                }
                if (n2 != 0 || date == null || date.getTime() > System.currentTimeMillis()) continue;
                break;
            }
            throw new TimeoutException("Timeout waiting for connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyPending(RouteSpecificPool<T, C, E> pool) {
        PoolEntryFuture<E> future = pool.nextPending();
        if (future != null) {
            this.pending.remove(future);
        } else {
            future = this.pending.poll();
        }
        if (future != null) {
            future.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E entry, boolean reusable) {
        this.lock.lock();
        try {
            if (this.leased.remove(entry)) {
                RouteSpecificPool pool = this.getPool(((PoolEntry)entry).getRoute());
                pool.free(entry, reusable);
                if (reusable && !this.isShutDown) {
                    this.available.add(entry);
                } else {
                    ((PoolEntry)entry).close();
                }
                this.notifyPending(pool);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMax(T route) {
        Integer v = this.maxPerRoute.get(route);
        if (v != null) {
            return v;
        }
        return this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTotal(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.maxTotal = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultMaxPerRoute(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Max value may not be negative or zero");
        }
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getStats(T route) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null");
        }
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> pool = this.getPool(route);
            PoolStats poolStats = new PoolStats(pool.getLeasedCount(), pool.getPendingCount(), pool.getAvailableCount(), this.getMax(route));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdle(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        long l2 = timeUnit.toMillis(l);
        if (l2 < 0L) {
            l2 = 0L;
        }
        long l3 = System.currentTimeMillis() - l2;
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                if (poolEntry.getUpdated() > l3) continue;
                poolEntry.close();
                RouteSpecificPool routeSpecificPool = this.getPool(poolEntry.getRoute());
                routeSpecificPool.remove(poolEntry);
                iterator.remove();
                this.notifyPending(routeSpecificPool);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(this.leased);
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available);
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

