/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.protocol;

import com.amazonaws.org.apache.http.HttpClientConnection;
import com.amazonaws.org.apache.http.HttpException;
import com.amazonaws.org.apache.http.HttpRequest;
import com.amazonaws.org.apache.http.HttpResponse;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import com.amazonaws.org.apache.http.protocol.HttpRequestExecutor;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.IOException;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        AWSRequestMetrics aWSRequestMetrics = (AWSRequestMetrics)httpContext.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (aWSRequestMetrics == null) {
            return super.doSendRequest(httpRequest, httpClientConnection, httpContext);
        }
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            HttpResponse httpResponse = super.doSendRequest(httpRequest, httpClientConnection, httpContext);
            return httpResponse;
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws HttpException, IOException {
        AWSRequestMetrics aWSRequestMetrics = (AWSRequestMetrics)httpContext.getAttribute(AWSRequestMetrics.class.getSimpleName());
        if (aWSRequestMetrics == null) {
            return super.doReceiveResponse(httpRequest, httpClientConnection, httpContext);
        }
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(httpRequest, httpClientConnection, httpContext);
            return httpResponse;
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

