/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.conn.ClientConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdleConnectionReaper
extends Thread {
    private static final int PERIOD_MILLISECONDS = 60000;
    private static final ArrayList<ClientConnectionManager> connectionManagers = new ArrayList();
    private volatile boolean shuttingDown;
    private static IdleConnectionReaper instance;
    static final Log log;

    private IdleConnectionReaper() {
        super("java-sdk-http-connection-reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(ClientConnectionManager clientConnectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.add(clientConnectionManager);
    }

    public static synchronized boolean removeConnectionManager(ClientConnectionManager clientConnectionManager) {
        boolean bl = connectionManagers.remove(clientConnectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return bl;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block6: while (true) {
            if (this.shuttingDown) {
                log.debug("Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(60000L);
                List list = null;
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.amazonaws.http.IdleConnectionReaper.class
                list = (List)connectionManagers.clone();
                // MONITOREXIT : object
                object = list.iterator();
                while (true) {
                    if (!object.hasNext()) continue block6;
                    ClientConnectionManager clientConnectionManager = (ClientConnectionManager)object.next();
                    try {
                        clientConnectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        log.warn("Unable to close idle connections", exception);
                    }
                }
            }
            catch (Throwable throwable) {
                log.debug("Reaper thread: ", throwable);
                continue;
            }
            break;
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    static synchronized int size() {
        return connectionManagers.size();
    }

    static {
        log = LogFactory.getLog(IdleConnectionReaper.class);
    }
}

