/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProgressListenerChain
implements ProgressListener {
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private final ProgressEventFilter progressEventFilter;
    private static final Log log = LogFactory.getLog(ProgressListenerChain.class);

    public ProgressListenerChain(ProgressListener ... progressListenerArray) {
        this((ProgressEventFilter)null, progressListenerArray);
    }

    public ProgressListenerChain(ProgressEventFilter progressEventFilter, ProgressListener ... progressListenerArray) {
        if (progressListenerArray == null) {
            throw new IllegalArgumentException("Progress Listeners cannot be null.");
        }
        for (ProgressListener progressListener : progressListenerArray) {
            this.addProgressListener(progressListener);
        }
        this.progressEventFilter = progressEventFilter;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        this.listeners.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        this.listeners.remove(progressListener);
    }

    protected List<ProgressListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEvent progressEvent2 = progressEvent;
        if (this.progressEventFilter != null && (progressEvent2 = this.progressEventFilter.filter(progressEvent)) == null) {
            return;
        }
        for (ProgressListener progressListener : this.listeners) {
            try {
                progressListener.progressChanged(progressEvent2);
            }
            catch (RuntimeException runtimeException) {
                log.warn("Couldn't update progress listener", runtimeException);
            }
        }
    }

    public static interface ProgressEventFilter {
        public ProgressEvent filter(ProgressEvent var1);
    }
}

