/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.util;

public abstract class NameTransformer {
    public static final NameTransformer NOP = new NameTransformer(){

        @Override
        public String transform(String name) {
            return name;
        }
    };

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(final String prefix, final String suffix) {
        boolean hasSuffix;
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean bl = hasSuffix = suffix != null && suffix.length() > 0;
        if (hasPrefix) {
            if (hasSuffix) {
                return new NameTransformer(){

                    @Override
                    public String transform(String name) {
                        return prefix + name + suffix;
                    }

                    public String toString() {
                        return "[PreAndSuffixTransformer('" + prefix + "','" + suffix + "')]";
                    }
                };
            }
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return prefix + name;
                }

                public String toString() {
                    return "[PrefixTransformer('" + prefix + "')]";
                }
            };
        }
        if (hasSuffix) {
            return new NameTransformer(){

                @Override
                public String transform(String name) {
                    return name + suffix;
                }

                public String toString() {
                    return "[SuffixTransformer('" + suffix + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer t1, NameTransformer t2) {
        return new Chained(t1, t2);
    }

    public abstract String transform(String var1);

    public static class Chained
    extends NameTransformer {
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer t1, NameTransformer t2) {
            this._t1 = t1;
            this._t2 = t2;
        }

        @Override
        public String transform(String name) {
            return this._t1.transform(this._t2.transform(name));
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }
}

