/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.InnerClassProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ManagedReferenceProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.amazonaws.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.util.Annotations;
import com.amazonaws.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import com.amazonaws.com.fasterxml.jackson.databind.util.NameTransformer;
import com.amazonaws.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BeanDeserializerBase
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer,
Serializable {
    private final transient Annotations _classAnnotations;
    protected final JavaType _beanType;
    protected final JsonFormat.Shape _serializationShape;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected boolean _nonStandardCreation;
    protected boolean _vanillaProcessing;
    protected final BeanPropertyMap _beanProperties;
    protected final ValueInjector[] _injectables;
    protected SettableAnyProperty _anySetter;
    protected final HashSet<String> _ignorableProps;
    protected final boolean _ignoreAllUnknown;
    protected final boolean _needViewProcesing;
    protected final Map<String, SettableBeanProperty> _backRefs;
    protected transient HashMap<ClassKey, JsonDeserializer<Object>> _subDeserializers;
    protected UnwrappedPropertyHandler _unwrappedPropertyHandler;
    protected ExternalTypeHandler _externalTypeIdHandler;
    protected final ObjectIdReader _objectIdReader;

    protected BeanDeserializerBase(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(beanDesc.getType());
        AnnotatedClass ac = beanDesc.getClassInfo();
        this._classAnnotations = ac.getAnnotations();
        this._beanType = beanDesc.getType();
        this._valueInstantiator = builder.getValueInstantiator();
        this._beanProperties = properties;
        this._backRefs = backRefs;
        this._ignorableProps = ignorableProps;
        this._ignoreAllUnknown = ignoreAllUnknown;
        this._anySetter = builder.getAnySetter();
        List<ValueInjector> injectables = builder.getInjectables();
        this._injectables = injectables == null || injectables.isEmpty() ? null : injectables.toArray(new ValueInjector[injectables.size()]);
        this._objectIdReader = builder.getObjectIdReader();
        this._nonStandardCreation = this._unwrappedPropertyHandler != null || this._valueInstantiator.canCreateUsingDelegate() || this._valueInstantiator.canCreateFromObjectWith() || !this._valueInstantiator.canCreateUsingDefault();
        JsonFormat.Value format = beanDesc.findExpectedFormat(null);
        this._serializationShape = format == null ? null : format.getShape();
        this._needViewProcesing = hasViews;
        this._vanillaProcessing = !this._nonStandardCreation && this._injectables == null && !this._needViewProcesing && this._objectIdReader != null;
    }

    protected BeanDeserializerBase(BeanDeserializerBase src) {
        this(src, src._ignoreAllUnknown);
    }

    protected BeanDeserializerBase(BeanDeserializerBase src, boolean ignoreAllUnknown) {
        super(src._beanType);
        this._classAnnotations = src._classAnnotations;
        this._beanType = src._beanType;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._beanProperties = src._beanProperties;
        this._backRefs = src._backRefs;
        this._ignorableProps = src._ignorableProps;
        this._ignoreAllUnknown = ignoreAllUnknown;
        this._anySetter = src._anySetter;
        this._injectables = src._injectables;
        this._objectIdReader = src._objectIdReader;
        this._nonStandardCreation = src._nonStandardCreation;
        this._unwrappedPropertyHandler = src._unwrappedPropertyHandler;
        this._needViewProcesing = src._needViewProcesing;
        this._serializationShape = src._serializationShape;
        this._vanillaProcessing = src._vanillaProcessing;
    }

    protected BeanDeserializerBase(BeanDeserializerBase src, NameTransformer unwrapper) {
        super(src._beanType);
        this._classAnnotations = src._classAnnotations;
        this._beanType = src._beanType;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._backRefs = src._backRefs;
        this._ignorableProps = src._ignorableProps;
        this._ignoreAllUnknown = unwrapper != null || src._ignoreAllUnknown;
        this._anySetter = src._anySetter;
        this._injectables = src._injectables;
        this._objectIdReader = src._objectIdReader;
        this._nonStandardCreation = src._nonStandardCreation;
        this._unwrappedPropertyHandler = src._unwrappedPropertyHandler;
        if (unwrapper != null) {
            if (this._unwrappedPropertyHandler != null) {
                this._unwrappedPropertyHandler.renameAll(unwrapper);
            }
            this._beanProperties = src._beanProperties.renameAll(unwrapper);
        } else {
            this._beanProperties = src._beanProperties;
        }
        this._needViewProcesing = src._needViewProcesing;
        this._serializationShape = src._serializationShape;
        this._vanillaProcessing = false;
    }

    public BeanDeserializerBase(BeanDeserializerBase src, ObjectIdReader oir) {
        super(src._beanType);
        this._classAnnotations = src._classAnnotations;
        this._beanType = src._beanType;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._backRefs = src._backRefs;
        this._ignorableProps = src._ignorableProps;
        this._ignoreAllUnknown = src._ignoreAllUnknown;
        this._anySetter = src._anySetter;
        this._injectables = src._injectables;
        this._nonStandardCreation = src._nonStandardCreation;
        this._unwrappedPropertyHandler = src._unwrappedPropertyHandler;
        this._needViewProcesing = src._needViewProcesing;
        this._serializationShape = src._serializationShape;
        this._vanillaProcessing = src._vanillaProcessing;
        this._objectIdReader = oir;
        this._beanProperties = oir == null ? src._beanProperties : src._beanProperties.withProperty(new ObjectIdValueProperty(oir));
    }

    public BeanDeserializerBase(BeanDeserializerBase src, HashSet<String> ignorableProps) {
        super(src._beanType);
        this._classAnnotations = src._classAnnotations;
        this._beanType = src._beanType;
        this._valueInstantiator = src._valueInstantiator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._backRefs = src._backRefs;
        this._ignorableProps = ignorableProps;
        this._ignoreAllUnknown = src._ignoreAllUnknown;
        this._anySetter = src._anySetter;
        this._injectables = src._injectables;
        this._nonStandardCreation = src._nonStandardCreation;
        this._unwrappedPropertyHandler = src._unwrappedPropertyHandler;
        this._needViewProcesing = src._needViewProcesing;
        this._serializationShape = src._serializationShape;
        this._vanillaProcessing = src._vanillaProcessing;
        this._objectIdReader = src._objectIdReader;
        this._beanProperties = src._beanProperties;
    }

    @Override
    public abstract JsonDeserializer<Object> unwrappingDeserializer(NameTransformer var1);

    public abstract BeanDeserializerBase withObjectIdReader(ObjectIdReader var1);

    public abstract BeanDeserializerBase withIgnorableProperties(HashSet<String> var1);

    protected abstract BeanDeserializerBase asArrayDeserializer();

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        Object object;
        Object object2;
        ExternalTypeHandler.Builder builder = null;
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object2 = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object2);
            for (SettableBeanProperty serializable : this._propertyBasedCreator.properties()) {
                if (!serializable.hasValueTypeDeserializer() || ((TypeDeserializer)(object = serializable.getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
                if (builder == null) {
                    builder = new ExternalTypeHandler.Builder();
                }
                builder.addExternal(serializable, (TypeDeserializer)object);
            }
        }
        object2 = null;
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            Object object3;
            JsonDeserializer<Object> jsonDeserializer;
            object = settableBeanProperty;
            if (!((SettableBeanProperty)object).hasValueDeserializer()) {
                object = ((SettableBeanProperty)object).withValueDeserializer(this.findDeserializer(deserializationContext, ((SettableBeanProperty)object).getType(), (BeanProperty)object));
            } else {
                jsonDeserializer = ((SettableBeanProperty)object).getValueDeserializer();
                if (jsonDeserializer instanceof ContextualDeserializer && (object3 = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(deserializationContext, (BeanProperty)object)) != jsonDeserializer) {
                    object = ((SettableBeanProperty)object).withValueDeserializer((JsonDeserializer<?>)object3);
                }
            }
            object = this._resolveManagedReferenceProperty(deserializationContext, (SettableBeanProperty)object);
            jsonDeserializer = this._resolveUnwrappedProperty(deserializationContext, (SettableBeanProperty)object);
            if (jsonDeserializer != null) {
                object = jsonDeserializer;
                if (object2 == null) {
                    object2 = new UnwrappedPropertyHandler();
                }
                object2.addProperty((SettableBeanProperty)object);
                continue;
            }
            if ((object = this._resolveInnerClassValuedProperty(deserializationContext, (SettableBeanProperty)object)) != settableBeanProperty) {
                this._beanProperties.replace((SettableBeanProperty)object);
            }
            if (!((SettableBeanProperty)object).hasValueTypeDeserializer() || ((TypeDeserializer)(object3 = ((SettableBeanProperty)object).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            if (builder == null) {
                builder = new ExternalTypeHandler.Builder();
            }
            builder.addExternal((SettableBeanProperty)object, (TypeDeserializer)object3);
            this._beanProperties.remove((SettableBeanProperty)object);
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            this._anySetter = this._anySetter.withValueDeserializer(this.findDeserializer(deserializationContext, this._anySetter.getType(), this._anySetter.getProperty()));
        }
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            JavaType javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (javaType == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._beanType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            AnnotatedWithParams annotatedWithParams = this._valueInstantiator.getDelegateCreator();
            object = new BeanProperty.Std(null, javaType, this._classAnnotations, annotatedWithParams);
            this._delegateDeserializer = this.findDeserializer(deserializationContext, javaType, (BeanProperty)object);
        }
        if (builder != null) {
            this._externalTypeIdHandler = builder.build();
            this._nonStandardCreation = true;
        }
        this._unwrappedPropertyHandler = object2;
        if (object2 != null) {
            this._nonStandardCreation = true;
        }
        this._vanillaProcessing = this._vanillaProcessing && !this._nonStandardCreation;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        AnnotatedMember annotatedMember;
        ObjectIdReader objectIdReader = this._objectIdReader;
        String[] stringArray = null;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        if (beanProperty != null && annotationIntrospector != null) {
            stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedMember);
            object3 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object3 != null) {
                ObjectIdGenerator objectIdGenerator;
                SettableBeanProperty settableBeanProperty;
                Object object4;
                object2 = ((ObjectIdInfo)(object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object3))).getGeneratorType();
                if (object2 == ObjectIdGenerators.PropertyGenerator.class) {
                    object4 = ((ObjectIdInfo)object3).getPropertyName();
                    settableBeanProperty = this.findProperty((String)object4);
                    if (settableBeanProperty == null) {
                        throw new IllegalArgumentException("Invalid Object Id definition for " + this.getBeanClass().getName() + ": can not find property with name '" + object4 + "'");
                    }
                    object = settableBeanProperty.getType();
                    objectIdGenerator = new PropertyBasedObjectIdGenerator(((ObjectIdInfo)object3).getScope());
                } else {
                    object4 = deserializationContext.constructType((Class<?>)object2);
                    object = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object4, ObjectIdGenerator.class)[0];
                    settableBeanProperty = null;
                    objectIdGenerator = deserializationContext.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
                }
                object4 = deserializationContext.findRootValueDeserializer((JavaType)object);
                objectIdReader = ObjectIdReader.construct((JavaType)object, ((ObjectIdInfo)object3).getPropertyName(), objectIdGenerator, object4, settableBeanProperty);
            }
        }
        object3 = this;
        if (objectIdReader != null && objectIdReader != this._objectIdReader) {
            object3 = ((BeanDeserializerBase)object3).withObjectIdReader(objectIdReader);
        }
        if (stringArray != null && stringArray.length != 0) {
            object2 = ArrayBuilders.setAndArray(((BeanDeserializerBase)object3)._ignorableProps, stringArray);
            object3 = ((BeanDeserializerBase)object3).withIgnorableProperties((HashSet<String>)object2);
        }
        object2 = null;
        if (annotatedMember != null && (object = annotationIntrospector.findFormat((Annotated)annotatedMember)) != null) {
            object2 = ((JsonFormat.Value)object).getShape();
        }
        if (object2 == null) {
            object2 = this._serializationShape;
        }
        if (object2 == JsonFormat.Shape.ARRAY) {
            object3 = ((BeanDeserializerBase)object3).asArrayDeserializer();
        }
        return object3;
    }

    protected SettableBeanProperty _resolveManagedReferenceProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        JsonDeserializer<Object> jsonDeserializer;
        String string = settableBeanProperty.getManagedReferenceName();
        if (string == null) {
            return settableBeanProperty;
        }
        JsonDeserializer<Object> jsonDeserializer2 = settableBeanProperty.getValueDeserializer();
        SettableBeanProperty settableBeanProperty2 = null;
        boolean bl = false;
        if (jsonDeserializer2 instanceof BeanDeserializerBase) {
            settableBeanProperty2 = ((BeanDeserializerBase)jsonDeserializer2).findBackReference(string);
        } else if (jsonDeserializer2 instanceof ContainerDeserializerBase) {
            jsonDeserializer = ((ContainerDeserializerBase)jsonDeserializer2).getContentDeserializer();
            if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
                String string2 = jsonDeserializer == null ? "NULL" : jsonDeserializer.getClass().getName();
                throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': value deserializer is of type ContainerDeserializerBase, but content type is not handled by a BeanDeserializer " + " (instead it's of type " + string2 + ")");
            }
            settableBeanProperty2 = ((BeanDeserializerBase)jsonDeserializer).findBackReference(string);
            bl = true;
        } else if (jsonDeserializer2 instanceof AbstractDeserializer) {
            settableBeanProperty2 = ((AbstractDeserializer)jsonDeserializer2).findBackReference(string);
        } else {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': type for value deserializer is not BeanDeserializer or ContainerDeserializerBase, but " + jsonDeserializer2.getClass().getName());
        }
        if (settableBeanProperty2 == null) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': no back reference property found from type " + settableBeanProperty.getType());
        }
        jsonDeserializer = this._beanType;
        JavaType javaType = settableBeanProperty2.getType();
        if (!javaType.getRawClass().isAssignableFrom(((JavaType)((Object)jsonDeserializer)).getRawClass())) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': back reference type (" + javaType.getRawClass().getName() + ") not compatible with managed type (" + ((JavaType)((Object)jsonDeserializer)).getRawClass().getName() + ")");
        }
        return new ManagedReferenceProperty(settableBeanProperty, string, settableBeanProperty2, this._classAnnotations, bl);
    }

    protected SettableBeanProperty _resolveUnwrappedProperty(DeserializationContext ctxt, SettableBeanProperty prop) {
        JsonDeserializer<Object> orig;
        JsonDeserializer<Object> unwrapping;
        NameTransformer unwrapper;
        AnnotatedMember am = prop.getMember();
        if (am != null && (unwrapper = ctxt.getAnnotationIntrospector().findUnwrappingNameTransformer(am)) != null && (unwrapping = (orig = prop.getValueDeserializer()).unwrappingDeserializer(unwrapper)) != orig && unwrapping != null) {
            return prop.withValueDeserializer(unwrapping);
        }
        return null;
    }

    protected SettableBeanProperty _resolveInnerClassValuedProperty(DeserializationContext ctxt, SettableBeanProperty prop) {
        Class<?> valueClass;
        Class<?> enclosing;
        BeanDeserializerBase bd;
        ValueInstantiator vi;
        JsonDeserializer<Object> deser = prop.getValueDeserializer();
        if (deser instanceof BeanDeserializerBase && !(vi = (bd = (BeanDeserializerBase)deser).getValueInstantiator()).canCreateUsingDefault() && (enclosing = ClassUtil.getOuterClass(valueClass = prop.getType().getRawClass())) != null && enclosing == this._beanType.getRawClass()) {
            for (Constructor<?> ctor : valueClass.getConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != 1 || paramTypes[0] != enclosing) continue;
                if (ctxt.getConfig().canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(ctor);
                }
                return new InnerClassProperty(prop, ctor);
            }
        }
        return prop;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        ArrayList<Object> names = new ArrayList<Object>();
        for (SettableBeanProperty prop : this._beanProperties) {
            names.add(prop.getName());
        }
        return names;
    }

    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    public SettableBeanProperty findProperty(String propertyName) {
        SettableBeanProperty prop;
        SettableBeanProperty settableBeanProperty = prop = this._beanProperties == null ? null : this._beanProperties.find(propertyName);
        if (prop == null && this._propertyBasedCreator != null) {
            prop = this._propertyBasedCreator.findCreatorProperty(propertyName);
        }
        return prop;
    }

    public SettableBeanProperty findBackReference(String logicalName) {
        if (this._backRefs == null) {
            return null;
        }
        return this._backRefs.get(logicalName);
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public final Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken t;
        if (this._objectIdReader != null && (t = jp.getCurrentToken()) != null && t.isScalarValue()) {
            return this.deserializeFromObjectId(jp, ctxt);
        }
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    protected Object deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object = this._objectIdReader.deserializer.deserialize(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator);
        Object object2 = readableObjectId.item;
        if (object2 == null) {
            throw new IllegalStateException("Could not resolve Object Id [" + object + "] -- unresolved forward-reference?");
        }
        return object2;
    }

    protected void injectValues(DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        for (ValueInjector injector : this._injectables) {
            injector.inject(ctxt, bean);
        }
    }

    @Override
    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object beanOrClass, String propName) throws IOException, JsonProcessingException {
        if (this._ignoreAllUnknown || this._ignorableProps != null && this._ignorableProps.contains(propName)) {
            jp.skipChildren();
            return;
        }
        super.handleUnknownProperty(jp, ctxt, beanOrClass, propName);
    }

    protected Object handleUnknownProperties(DeserializationContext ctxt, Object bean, TokenBuffer unknownTokens) throws IOException, JsonProcessingException {
        unknownTokens.writeEndObject();
        JsonParser bufferParser = unknownTokens.asParser();
        while (bufferParser.nextToken() != JsonToken.END_OBJECT) {
            String propName = bufferParser.getCurrentName();
            bufferParser.nextToken();
            this.handleUnknownProperty(bufferParser, ctxt, bean, propName);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _findSubclassDeserializer(DeserializationContext ctxt, Object bean, TokenBuffer unknownTokens) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> subDeser;
        BeanDeserializerBase beanDeserializerBase = this;
        synchronized (beanDeserializerBase) {
            subDeser = this._subDeserializers == null ? null : this._subDeserializers.get(new ClassKey(bean.getClass()));
        }
        if (subDeser != null) {
            return subDeser;
        }
        JavaType type = ctxt.constructType(bean.getClass());
        subDeser = ctxt.findRootValueDeserializer(type);
        if (subDeser != null) {
            BeanDeserializerBase beanDeserializerBase2 = this;
            synchronized (beanDeserializerBase2) {
                if (this._subDeserializers == null) {
                    this._subDeserializers = new HashMap();
                }
                this._subDeserializers.put(new ClassKey(bean.getClass()), subDeser);
            }
        }
        return subDeser;
    }

    public void wrapAndThrow(Throwable t, Object bean, String fieldName, DeserializationContext ctxt) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap || !(t instanceof JsonMappingException)) {
                throw (IOException)t;
            }
        } else if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, fieldName);
    }

    protected void wrapInstantiationProblem(Throwable t, DeserializationContext ctxt) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = ctxt == null || ctxt.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw ctxt.instantiationException(this._beanType.getRawClass(), t);
    }
}

