/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

public class ProfilesConfigFileLoader {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileLoader.class);

    public static Map<String, Profile> loadProfiles(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("AWS credential profiles file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Map<String, Profile> map = ProfilesConfigFileLoader.loadProfiles(fileInputStream);
            return map;
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Unable to load AWS credential profiles file at: " + file.getAbsolutePath(), iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, Profile> loadProfiles(InputStream inputStream) throws IOException {
        ProfilesConfigFileLoaderHelper profilesConfigFileLoaderHelper = new ProfilesConfigFileLoaderHelper();
        Map<String, Map<String, String>> map = profilesConfigFileLoaderHelper.parseProfileProperties(new Scanner(inputStream));
        LinkedHashMap<String, Profile> linkedHashMap = new LinkedHashMap<String, Profile>();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            String string = entry.getKey();
            Map<String, String> map2 = entry.getValue();
            if (string.startsWith("profile ")) {
                LOG.warn("The legacy profile format requires the 'profile ' prefix before the profile name. The latest code does not require such prefix, and will consider it as part of the profile name. Please remove the prefix if you are seeing this warning.");
            }
            String string2 = map2.get("aws_access_key_id");
            String string3 = map2.get("aws_secret_access_key");
            String string4 = map2.get("aws_session_token");
            ProfilesConfigFileLoader.assertParameterNotEmpty(string, "Unable to load credentials into profile: ProfileName is empty.");
            if (string2 == null) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", string));
            }
            if (string3 == null) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", string));
            }
            if (string4 == null) {
                linkedHashMap.put(string, new Profile(string, new BasicAWSCredentials(string2, string3)));
                continue;
            }
            if (string4.isEmpty()) {
                throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", string));
            }
            linkedHashMap.put(string, new Profile(string, new BasicSessionCredentials(string2, string3, string4)));
        }
        return linkedHashMap;
    }

    private static void assertParameterNotEmpty(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new AmazonClientException(string2);
        }
    }

    private static class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        @Override
        protected void onEmptyOrCommentLine(String string, String string2) {
        }

        @Override
        protected void onProfileStartingLine(String string, String string2) {
            this.allProfileProperties.put(string, new HashMap());
        }

        @Override
        protected void onProfileEndingLine(String string) {
        }

        @Override
        protected void onProfileProperty(String string, String string2, String string3, boolean bl, String string4) {
            Map<String, String> map;
            if (!bl) {
                LOG.info(String.format("Skip unsupported property name %s in profile [%s].", string2, string));
                return;
            }
            if (this.allProfileProperties.get(string) == null) {
                this.allProfileProperties.put(string, new HashMap());
            }
            if ((map = this.allProfileProperties.get(string)).containsKey(string2)) {
                throw new IllegalArgumentException("Duplicate property values for [" + string2 + "].");
            }
            map.put(string2, string3);
        }

        @Override
        protected void onEndOfFile() {
        }
    }
}

