/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSAbstractCognitoIdentityProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;

public class AWSBasicCognitoIdentityProvider
extends AWSAbstractCognitoIdentityProvider {
    protected final AmazonCognitoIdentity cib;

    public AWSBasicCognitoIdentityProvider(String string, String string2) {
        this(string, string2, new ClientConfiguration());
    }

    public AWSBasicCognitoIdentityProvider(String string, String string2, ClientConfiguration clientConfiguration) {
        this(string, string2, new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration));
    }

    public AWSBasicCognitoIdentityProvider(String string, String string2, AmazonCognitoIdentity amazonCognitoIdentity) {
        super(string, string2);
        this.cib = amazonCognitoIdentity;
    }

    @Override
    public String getToken() {
        GetOpenIdTokenRequest getOpenIdTokenRequest = new GetOpenIdTokenRequest().withIdentityId(super.getIdentityId()).withLogins(this.loginsMap);
        this.appendUserAgent(getOpenIdTokenRequest, this.getUserAgent());
        GetOpenIdTokenResult getOpenIdTokenResult = this.cib.getOpenIdToken(getOpenIdTokenRequest);
        if (!getOpenIdTokenResult.getIdentityId().equals(super.getIdentityId())) {
            this.identityChanged(getOpenIdTokenResult.getIdentityId());
        }
        return getOpenIdTokenResult.getToken();
    }

    @Override
    public String getIdentityId() {
        if (super.getIdentityId() == null) {
            GetIdRequest getIdRequest = new GetIdRequest().withAccountId(this.getAccountId()).withIdentityPoolId(this.getIdentityPoolId()).withLogins(this.loginsMap);
            this.appendUserAgent(getIdRequest, this.getUserAgent());
            GetIdResult getIdResult = this.cib.getId(getIdRequest);
            if (getIdResult.getIdentityId() != null) {
                this.identityChanged(getIdResult.getIdentityId());
            }
        }
        return super.getIdentityId();
    }

    @Override
    public String getProviderName() {
        return "Cognito";
    }

    @Override
    public String refresh() {
        this.getIdentityId();
        String string = this.getToken();
        this.update(this.getIdentityId(), string);
        return string;
    }
}

