/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.com.fasterxml.jackson.core.JsonFactory;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazonaws.com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public enum Jackson {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter writer;
    private static final ObjectWriter prettyWriter;

    public static String toJsonPrettyString(Object object) {
        try {
            return prettyWriter.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static String toJsonString(Object object) {
        try {
            return writer.writeValueAsString(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static <T> T fromJsonString(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        try {
            return objectMapper.readValue(string, clazz);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to parse Json String.", exception);
        }
    }

    public static JsonNode jsonNodeOf(String string) {
        return Jackson.fromJsonString(string, JsonNode.class);
    }

    public static JsonGenerator jsonGeneratorOf(Writer writer) throws IOException {
        return new JsonFactory().createGenerator(writer);
    }

    public static <T> T loadFrom(File file, Class<T> clazz) throws IOException {
        try {
            return objectMapper.readValue(file, clazz);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectWriter getPrettywriter() {
        return prettyWriter;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        writer = objectMapper.writer();
        prettyWriter = objectMapper.writerWithDefaultPrettyPrinter();
    }
}

