/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListIdentitiesRequestMarshaller
implements Marshaller<Request<ListIdentitiesRequest>, ListIdentitiesRequest> {
    @Override
    public Request<ListIdentitiesRequest> marshall(ListIdentitiesRequest listIdentitiesRequest) {
        if (listIdentitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListIdentitiesRequest> defaultRequest = new DefaultRequest<ListIdentitiesRequest>(listIdentitiesRequest, "AmazonCognitoIdentity");
        String string = "AWSCognitoIdentityService.ListIdentities";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.POST);
        defaultRequest.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter(stringWriter);
            jSONWriter.object();
            if (listIdentitiesRequest.getIdentityPoolId() != null) {
                jSONWriter.key("IdentityPoolId").value(listIdentitiesRequest.getIdentityPoolId());
            }
            if (listIdentitiesRequest.getMaxResults() != null) {
                jSONWriter.key("MaxResults").value(listIdentitiesRequest.getMaxResults());
            }
            if (listIdentitiesRequest.getNextToken() != null) {
                jSONWriter.key("NextToken").value(listIdentitiesRequest.getNextToken());
            }
            jSONWriter.endObject();
            String string2 = stringWriter.toString();
            byte[] byArray = string2.getBytes(StringUtils.UTF8);
            defaultRequest.setContent(new StringInputStream(string2));
            defaultRequest.addHeader("Content-Length", Integer.toString(byArray.length));
            defaultRequest.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable throwable) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + throwable.getMessage(), throwable);
        }
        return defaultRequest;
    }
}

