/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadataParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;

public class RegionUtils {
    private static final String FALLBACK = "regions.xml";
    private static List<Region> regions;
    private static final Log log;

    public static synchronized List<Region> getRegions() {
        if (regions == null) {
            RegionUtils.init();
        }
        return regions;
    }

    public static synchronized List<Region> getRegionsForService(String string) {
        LinkedList<Region> linkedList = new LinkedList<Region>();
        for (Region region : RegionUtils.getRegions()) {
            if (!region.isServiceSupported(string)) continue;
            linkedList.add(region);
        }
        return linkedList;
    }

    public static Region getRegion(String string) {
        for (Region region : RegionUtils.getRegions()) {
            if (!region.getName().equals(string)) continue;
            return region;
        }
        return null;
    }

    public static Region getRegionByEndpoint(String string) {
        URI uRI = RegionUtils.getUriByEndpoint(string);
        String string2 = uRI.getHost();
        for (Region region : RegionUtils.getRegions()) {
            for (String string3 : region.getServiceEndpoints().values()) {
                URI uRI2 = RegionUtils.getUriByEndpoint(string3);
                if (!uRI2.getHost().equals(string2)) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + string);
    }

    public static synchronized void init() {
        if (System.getProperty("com.amazonaws.regions.RegionUtils.fileOverride") != null) {
            try {
                RegionUtils.loadRegionsFromOverrideFile();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Couldn't find regions override file specified", fileNotFoundException);
            }
        }
        if (regions == null) {
            RegionUtils.initSDKRegions();
        }
        if (regions == null) {
            throw new RuntimeException("Failed to initialize the regions.");
        }
    }

    private static void loadRegionsFromOverrideFile() throws FileNotFoundException {
        String string = System.getProperty("com.amazonaws.regions.RegionUtils.fileOverride");
        if (log.isDebugEnabled()) {
            log.debug("Using local override of the regions file (" + string + ") to initiate regions data...");
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        RegionUtils.initRegions(fileInputStream);
    }

    private static void initRegions(InputStream inputStream) {
        try {
            RegionMetadataParser regionMetadataParser = new RegionMetadataParser();
            regions = regionMetadataParser.parseRegionMetadata(inputStream);
        }
        catch (Exception exception) {
            log.warn("Failed to parse regional endpoints", exception);
        }
    }

    private static void initSDKRegions() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing the regions from the region file bundled with the SDK...");
        }
        InputStream inputStream = RegionUtils.class.getResourceAsStream(FALLBACK);
        RegionUtils.initRegions(inputStream);
    }

    private static URI getUriByEndpoint(String string) {
        URI uRI = null;
        try {
            uRI = new URI(string);
            if (uRI.getHost() == null) {
                uRI = new URI("http://" + string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unable to parse service endpoint: " + uRISyntaxException.getMessage());
        }
        return uRI;
    }

    static {
        log = LogFactory.getLog("com.amazonaws.request");
    }
}

