/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.chrono;

import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.chrono.AssembledChronology;
import com.amazonaws.org.joda.time.chrono.BasicGJChronology;
import com.amazonaws.org.joda.time.chrono.ZonedChronology;
import java.util.HashMap;
import java.util.Map;

public final class GregorianChronology
extends BasicGJChronology {
    private static final GregorianChronology INSTANCE_UTC;
    private static final Map<DateTimeZone, GregorianChronology[]> cCache;

    public static GregorianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static GregorianChronology getInstance(DateTimeZone dateTimeZone) {
        return GregorianChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GregorianChronology getInstance(DateTimeZone dateTimeZone, int n) {
        GregorianChronology gregorianChronology;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, GregorianChronology[]> map = cCache;
        synchronized (map) {
            GregorianChronology[] gregorianChronologyArray = cCache.get(dateTimeZone);
            if (gregorianChronologyArray == null) {
                gregorianChronologyArray = new GregorianChronology[7];
                cCache.put(dateTimeZone, gregorianChronologyArray);
            }
            try {
                gregorianChronology = gregorianChronologyArray[n - 1];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Invalid min days in first week: " + n);
            }
            if (gregorianChronology == null) {
                if (dateTimeZone == DateTimeZone.UTC) {
                    gregorianChronology = new GregorianChronology(null, null, n);
                } else {
                    gregorianChronology = GregorianChronology.getInstance(DateTimeZone.UTC, n);
                    gregorianChronology = new GregorianChronology(ZonedChronology.getInstance(gregorianChronology, dateTimeZone), null, n);
                }
                gregorianChronologyArray[n - 1] = gregorianChronology;
            }
        }
        return gregorianChronology;
    }

    private GregorianChronology(Chronology chronology, Object object, int n) {
        super(chronology, object, n);
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return GregorianChronology.getInstance(dateTimeZone);
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
        }
    }

    boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    long calculateFirstDayOfYearMillis(int n) {
        int n2 = n / 100;
        if (n < 0) {
            n2 = (n + 3 >> 2) - n2 + (n2 + 3 >> 2) - 1;
        } else {
            n2 = (n >> 2) - n2 + (n2 >> 2);
            if (this.isLeapYear(n)) {
                --n2;
            }
        }
        return ((long)n * 365L + (long)(n2 - 719527)) * 86400000L;
    }

    int getMinYear() {
        return -292275054;
    }

    int getMaxYear() {
        return 292278993;
    }

    long getAverageMillisPerYear() {
        return 31556952000L;
    }

    long getAverageMillisPerYearDividedByTwo() {
        return 15778476000L;
    }

    long getAverageMillisPerMonth() {
        return 2629746000L;
    }

    long getApproxMillisAtEpochDividedByTwo() {
        return 31083597720000L;
    }

    static {
        cCache = new HashMap<DateTimeZone, GregorianChronology[]>();
        INSTANCE_UTC = GregorianChronology.getInstance(DateTimeZone.UTC);
    }
}

