/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ProgressListenerCallbackExecutor {
    private final ProgressListener listener;
    private static final ExecutorService executor = ProgressListenerCallbackExecutor.createNewExecutorService();

    public static Future<?> progressChanged(final ProgressListener progressListener, final ProgressEvent progressEvent) {
        if (progressListener == null) {
            return null;
        }
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                progressListener.progressChanged(progressEvent);
            }
        });
    }

    public ProgressListenerCallbackExecutor(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    public ProgressListenerCallbackExecutor() {
        this.listener = null;
    }

    public void progressChanged(final ProgressEvent progressEvent) {
        if (this.listener == null) {
            return;
        }
        executor.submit(new Runnable(){

            @Override
            public void run() {
                ProgressListenerCallbackExecutor.this.listener.progressChanged(progressEvent);
            }
        });
    }

    protected ProgressListener getListener() {
        return this.listener;
    }

    protected static ExecutorService getExecutorService() {
        return executor;
    }

    public static ProgressListenerCallbackExecutor wrapListener(ProgressListener progressListener) {
        return progressListener == null ? null : new ProgressListenerCallbackExecutor(progressListener);
    }

    private static ExecutorService createNewExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("java-sdk-progress-listener-callback-thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }
}

