/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser.impl;

import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.core.io.SerializedString;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;

public final class ObjectIdWriter {
    public final JavaType idType;
    public final SerializedString propertyName;
    public final ObjectIdGenerator<?> generator;
    public final JsonSerializer<Object> serializer;
    public final boolean alwaysAsId;

    protected ObjectIdWriter(JavaType t, SerializedString propName, ObjectIdGenerator<?> gen, JsonSerializer<?> ser, boolean alwaysAsId) {
        this.idType = t;
        this.propertyName = propName;
        this.generator = gen;
        this.serializer = ser;
        this.alwaysAsId = alwaysAsId;
    }

    public static ObjectIdWriter construct(JavaType idType, String propName, ObjectIdGenerator<?> generator, boolean alwaysAsId) {
        SerializedString serName = propName == null ? null : new SerializedString(propName);
        return new ObjectIdWriter(idType, serName, generator, null, alwaysAsId);
    }

    public ObjectIdWriter withSerializer(JsonSerializer<?> ser) {
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, ser, this.alwaysAsId);
    }

    public ObjectIdWriter withAlwaysAsId(boolean newState) {
        if (newState == this.alwaysAsId) {
            return this;
        }
        return new ObjectIdWriter(this.idType, this.propertyName, this.generator, this.serializer, newState);
    }
}

