/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.core.io;

import com.amazonaws.com.fasterxml.jackson.core.SerializableString;
import com.amazonaws.com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.Serializable;

public class SerializedString
implements SerializableString,
Serializable {
    protected final String _value;
    protected char[] _quotedChars;

    public SerializedString(String v) {
        if (v == null) {
            throw new IllegalStateException("Null String illegal for SerializedString");
        }
        this._value = v;
    }

    @Override
    public final String getValue() {
        return this._value;
    }

    @Override
    public final char[] asQuotedChars() {
        char[] result = this._quotedChars;
        if (result == null) {
            this._quotedChars = result = JsonStringEncoder.getInstance().quoteAsString(this._value);
        }
        return result;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SerializedString other = (SerializedString)o;
        return this._value.equals(other._value);
    }
}

