/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class AWS3Signer
extends AbstractAWSSigner {
    private static final String AUTHORIZATION_HEADER = "X-Amzn-Authorization";
    private static final String NONCE_HEADER = "x-amz-nonce";
    private static final String HTTP_SCHEME = "AWS3";
    private static final String HTTPS_SCHEME = "AWS3-HTTPS";
    private String overriddenDate;
    @Deprecated
    protected static final DateUtils dateUtils = new DateUtils();
    private static final Log log = LogFactory.getLog(AWS3Signer.class);

    @Override
    public void sign(Request<?> request, AWSCredentials aWSCredentials) throws AmazonClientException {
        String string;
        byte[] byArray;
        String string2;
        if (aWSCredentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        SigningAlgorithm signingAlgorithm = SigningAlgorithm.HmacSHA256;
        String string3 = UUID.randomUUID().toString();
        int n = this.getTimeOffset(request);
        Date date = this.getSignatureDate(n);
        String string4 = DateUtils.formatRFC822Date(date);
        boolean bl = false;
        if (this.overriddenDate != null) {
            string4 = this.overriddenDate;
        }
        request.addHeader("Date", string4);
        request.addHeader("X-Amz-Date", string4);
        String string5 = request.getEndpoint().getHost();
        if (HttpUtils.isUsingNonDefaultPort(request.getEndpoint())) {
            string5 = string5 + ":" + request.getEndpoint().getPort();
        }
        request.addHeader("Host", string5);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)aWSCredentials2);
        }
        if (bl) {
            request.addHeader(NONCE_HEADER, string3);
            string2 = string4 + string3;
            byArray = string2.getBytes(StringUtils.UTF8);
        } else {
            string = HttpUtils.appendUri(request.getEndpoint().getPath(), request.getResourcePath());
            string2 = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(string) + "\n" + this.getCanonicalizedQueryString(request.getParameters()) + "\n" + this.getCanonicalizedHeadersForStringToSign(request) + "\n" + this.getRequestPayloadWithoutQueryParams(request);
            byArray = this.hash(string2);
        }
        log.debug("Calculated StringToSign: " + string2);
        string = this.signAndBase64Encode(byArray, aWSCredentials2.getAWSSecretKey(), signingAlgorithm);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl ? HTTPS_SCHEME : HTTP_SCHEME).append(" ");
        stringBuilder.append("AWSAccessKeyId=" + aWSCredentials2.getAWSAccessKeyId() + ",");
        stringBuilder.append("Algorithm=" + signingAlgorithm.toString() + ",");
        if (!bl) {
            stringBuilder.append(this.getSignedHeadersComponent(request) + ",");
        }
        stringBuilder.append("Signature=" + string);
        request.addHeader(AUTHORIZATION_HEADER, stringBuilder.toString());
    }

    private String getSignedHeadersComponent(Request<?> request) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SignedHeaders=");
        boolean bl = true;
        for (String string : this.getHeadersForStringToSign(request)) {
            if (!bl) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    protected List<String> getHeadersForStringToSign(Request<?> request) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            String string = entry.getKey();
            String string2 = string.toLowerCase();
            if (!string2.startsWith("x-amz") && !string2.equals("host")) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    void overrideDate(String string) {
        this.overriddenDate = string;
    }

    protected String getCanonicalizedHeadersForStringToSign(Request<?> request) {
        List<String> list = this.getHeadersForStringToSign(request);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, list.get(i).toLowerCase());
        }
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (!list.contains(entry.getKey().toLowerCase())) continue;
            treeMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append(((String)entry.getKey()).toLowerCase()).append(":").append((String)entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    protected boolean shouldUseHttpsScheme(Request<?> request) throws AmazonClientException {
        try {
            String string = request.getEndpoint().toURL().getProtocol().toLowerCase();
            if (string.equals("http")) {
                return false;
            }
            if (string.equals("https")) {
                return true;
            }
            throw new AmazonClientException("Unknown request endpoint protocol encountered while signing request: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AmazonClientException("Unable to parse request endpoint during signing", malformedURLException);
        }
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials aWSSessionCredentials) {
        request.addHeader("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

