/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ServiceNameFactory;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.Classes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AmazonWebServiceClient {
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    public static final boolean LOGGING_AWS_REQUEST_METRIC = true;
    private static final Log log = LogFactory.getLog(AmazonWebServiceClient.class);
    protected volatile URI endpoint;
    private volatile String signerRegionOverride;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler2> requestHandler2s;
    protected int timeOffset;
    private volatile Signer signer;
    private volatile String serviceName;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector);
        this.requestHandler2s = new CopyOnWriteArrayList<RequestHandler2>();
    }

    protected Signer getSigner() {
        return this.signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String string) throws IllegalArgumentException {
        URI uRI = this.toURI(string);
        Signer signer = this.computeSignerByURI(uRI, this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uRI;
            this.signer = signer;
        }
    }

    private URI toURI(String string) throws IllegalArgumentException {
        if (!string.contains("://")) {
            string = this.clientConfiguration.getProtocol().toString() + "://" + string;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String string, String string2, String string3) {
        URI uRI = this.toURI(string);
        Signer signer = this.computeSignerByServiceRegion(string2, string3, string3, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signer = signer;
            this.endpoint = uRI;
            this.signerRegionOverride = string3;
        }
    }

    @Deprecated
    protected void configSigner(URI uRI) {
    }

    @Deprecated
    protected void configSigner(String string, String string2) {
    }

    public Signer getSignerByURI(URI uRI) {
        return this.computeSignerByURI(uRI, this.signerRegionOverride, true);
    }

    private Signer computeSignerByURI(URI uRI, String string, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("Endpoint is not set. Use setEndpoint to set an endpoint before performing any request.");
        }
        String string2 = this.getServiceNameIntern();
        String string3 = AwsHostNameUtils.parseRegionName(uRI.getHost(), string2);
        return this.computeSignerByServiceRegion(string2, string3, string, bl);
    }

    private Signer computeSignerByServiceRegion(String string, String string2, String string3, boolean bl) {
        Signer signer;
        String string4 = this.clientConfiguration.getSignerOverride();
        Signer signer2 = signer = string4 == null ? SignerFactory.getSigner(string, string2) : SignerFactory.getSignerByTypeAndService(string4, string);
        if (signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionAwareSigner = (RegionAwareSigner)signer;
            if (string3 != null) {
                regionAwareSigner.setRegionName(string3);
            } else if (string2 != null && bl) {
                regionAwareSigner.setRegionName(string2);
            }
        }
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegion(Region region) throws IllegalArgumentException {
        String string;
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String string2 = this.getServiceNameIntern();
        if (region.isServiceSupported(string2)) {
            string = region.getServiceEndpoint(string2);
            int n = string.indexOf("://");
            if (n >= 0) {
                string = string.substring(n + "://".length());
            }
        } else {
            string = String.format("%s.%s.%s", string2, region.getName(), region.getDomain());
            log.info("{" + string2 + ", " + region.getName() + "} was not " + "found in region metadata, trying to construct an " + "endpoint using the standard pattern for this region: '" + string + "'.");
        }
        URI uRI = this.toURI(string);
        Signer signer = this.computeSignerByServiceRegion(string2, region.getName(), this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uRI;
            this.signer = signer;
        }
    }

    @Deprecated
    public void setConfiguration(ClientConfiguration clientConfiguration) {
        AmazonHttpClient amazonHttpClient = this.client;
        RequestMetricCollector requestMetricCollector = null;
        if (amazonHttpClient != null) {
            requestMetricCollector = amazonHttpClient.getRequestMetricCollector();
            amazonHttpClient.shutdown();
        }
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    protected <T> HttpRequest convertToHttpRequest(Request<T> request, HttpMethodName httpMethodName) {
        HttpRequest httpRequest = new HttpRequest(httpMethodName);
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            httpRequest.addParameter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        httpRequest.setOriginalRequest(request.getOriginalRequest());
        return httpRequest;
    }

    @Deprecated
    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.add(RequestHandler2.adapt(requestHandler));
    }

    public void addRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.add(requestHandler2);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.remove(RequestHandler2.adapt(requestHandler));
    }

    public void removeRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.remove(requestHandler2);
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest amazonWebServiceRequest) {
        boolean bl = this.isRequestMetricsEnabled(amazonWebServiceRequest) || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, bl, this);
    }

    protected final ExecutionContext createExecutionContext(Request<?> request) {
        return this.createExecutionContext(request.getOriginalRequest());
    }

    @Deprecated
    protected final ExecutionContext createExecutionContext() {
        boolean bl = this.isRMCEnabledAtClientOrSdkLevel() || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, bl, this);
    }

    protected static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    protected final boolean isRequestMetricsEnabled(AmazonWebServiceRequest amazonWebServiceRequest) {
        RequestMetricCollector requestMetricCollector = amazonWebServiceRequest.getRequestMetricCollector();
        if (requestMetricCollector != null && requestMetricCollector.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector requestMetricCollector = this.requestMetricCollector();
        return requestMetricCollector != null && requestMetricCollector.isEnabled();
    }

    public void setTimeOffset(int n) {
        this.timeOffset = n;
    }

    public AmazonWebServiceClient withTimeOffset(int n) {
        this.setTimeOffset(n);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector requestMetricCollector = this.client.getRequestMetricCollector();
        return requestMetricCollector == null ? AwsSdkMetrics.getRequestMetricCollector() : requestMetricCollector;
    }

    protected final RequestMetricCollector findRequestMetricCollector(Request<?> request) {
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        RequestMetricCollector requestMetricCollector = amazonWebServiceRequest.getRequestMetricCollector();
        if (requestMetricCollector != null) {
            return requestMetricCollector;
        }
        requestMetricCollector = this.getRequestMetricsCollector();
        return requestMetricCollector == null ? AwsSdkMetrics.getRequestMetricCollector() : requestMetricCollector;
    }

    protected final void endClientExecution(AWSRequestMetrics aWSRequestMetrics, Request<?> request, Response<?> response) {
        this.endClientExecution(aWSRequestMetrics, request, response, false);
    }

    protected final void endClientExecution(AWSRequestMetrics aWSRequestMetrics, Request<?> request, Response<?> response, boolean bl) {
        if (request != null) {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            aWSRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector requestMetricCollector = this.findRequestMetricCollector(request);
            requestMetricCollector.collectMetrics(request, response);
        }
        if (bl) {
            aWSRequestMetrics.log();
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String string) {
        this.serviceName = string;
    }

    private String computeServiceName() {
        int n;
        Class<?> clazz = Classes.childClassOf(AmazonWebServiceClient.class, this);
        String string = clazz.getSimpleName();
        String string2 = ServiceNameFactory.getServiceName(string);
        if (string2 != null) {
            return string2;
        }
        int n2 = string.indexOf("JavaClient");
        if (n2 == -1 && (n2 = string.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + string);
        }
        int n3 = string.indexOf(AMAZON);
        if (n3 == -1) {
            n3 = string.indexOf(AWS);
            if (n3 == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + string);
            }
            n = AWS.length();
        } else {
            n = AMAZON.length();
        }
        if (n3 >= n2) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + string);
        }
        String string3 = string.substring(n3 + n, n2);
        return string3.toLowerCase();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String string) {
        Signer signer = this.computeSignerByURI(this.endpoint, string, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signer = signer;
            this.signerRegionOverride = string;
        }
    }
}

