/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.format.DateTimeFormat;
import com.amazonaws.org.joda.time.format.DateTimeFormatter;
import com.amazonaws.org.joda.time.format.ISODateTimeFormat;
import com.amazonaws.org.joda.time.tz.FixedDateTimeZone;
import com.amazonaws.util.JodaTime;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    private static final long MILLI_SECONDS_OF_365_DAYS = 31536000000L;
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter compressedIso8601DateFormat = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmss'Z'").withZone(GMT);

    @Deprecated
    public Date parseIso8601Date(String string) {
        return DateUtils.parseISO8601Date(string);
    }

    public static Date parseISO8601Date(String string) {
        try {
            return DateUtils.doParseISO8601Date(string);
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    static Date doParseISO8601Date(String string) {
        String string2 = DateUtils.tempDateStringForJodaTime(string);
        try {
            if (string2.equals(string)) {
                return new Date(iso8601DateFormat.parseMillis(string));
            }
            long l = iso8601DateFormat.parseMillis(string2);
            long l2 = l + 31536000000L;
            if (l2 < 0L) {
                return new Date(iso8601DateFormat.parseMillis(string));
            }
            return new Date(l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new Date(alternateIso8601DateFormat.parseMillis(string));
            }
            catch (Exception exception) {
                throw illegalArgumentException;
            }
        }
    }

    private static String tempDateStringForJodaTime(String string) {
        return string.startsWith("292278994-") ? "292278993-" + string.substring("292278994-".length()) : string;
    }

    private static <E extends RuntimeException> E handleException(E e) {
        if (JodaTime.hasExpectedBehavior()) {
            return e;
        }
        throw new IllegalStateException("Joda-time 2.2 or later version is required, but found version: " + JodaTime.getVersion(), e);
    }

    @Deprecated
    public String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static String formatISO8601Date(Date date) {
        try {
            return iso8601DateFormat.print(date.getTime());
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    @Deprecated
    public Date parseRfc822Date(String string) {
        return DateUtils.parseRFC822Date(string);
    }

    public static Date parseRFC822Date(String string) {
        try {
            return new Date(rfc822DateFormat.parseMillis(string));
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    @Deprecated
    public String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date(date);
    }

    public static String formatRFC822Date(Date date) {
        try {
            return rfc822DateFormat.print(date.getTime());
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    @Deprecated
    public Date parseCompressedIso8601Date(String string) {
        return DateUtils.parseCompressedISO8601Date(string);
    }

    public static Date parseCompressedISO8601Date(String string) {
        try {
            return new Date(compressedIso8601DateFormat.parseMillis(string));
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }
}

