/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Codec;
import com.amazonaws.util.CodecUtils;

abstract class AbstractBase32Codec
implements Codec {
    private static final int MASK_2BITS = 3;
    private static final int MASK_3BITS = 7;
    private static final int MASK_4BITS = 15;
    private static final int MASK_5BITS = 31;
    private static final byte PAD = 61;
    private final byte[] ALPAHBETS;

    protected AbstractBase32Codec(byte[] byArray) {
        this.ALPAHBETS = byArray;
    }

    @Override
    public final byte[] encode(byte[] byArray) {
        int n = byArray.length / 5;
        int n2 = byArray.length % 5;
        if (n2 == 0) {
            byte[] byArray2 = new byte[n * 8];
            int n3 = 0;
            int n4 = 0;
            while (n3 < byArray.length) {
                this.encode5bytes(byArray, n3, byArray2, n4);
                n3 += 5;
                n4 += 8;
            }
            return byArray2;
        }
        byte[] byArray3 = new byte[(n + 1) * 8];
        int n5 = 0;
        int n6 = 0;
        while (n5 < byArray.length - n2) {
            this.encode5bytes(byArray, n5, byArray3, n6);
            n5 += 5;
            n6 += 8;
        }
        switch (n2) {
            case 1: {
                this.encode1byte(byArray, n5, byArray3, n6);
                break;
            }
            case 2: {
                this.encode2bytes(byArray, n5, byArray3, n6);
                break;
            }
            case 3: {
                this.encode3bytes(byArray, n5, byArray3, n6);
                break;
            }
            case 4: {
                this.encode4bytes(byArray, n5, byArray3, n6);
            }
        }
        return byArray3;
    }

    private final void encode5bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.ALPAHBETS[by >>> 3 & 0x1F];
        int n4 = n2++;
        int n5 = (by & 7) << 2;
        by = byArray[n++];
        byArray2[n4] = this.ALPAHBETS[n5 | by >>> 6 & 3];
        byArray2[n2++] = this.ALPAHBETS[by >>> 1 & 0x1F];
        int n6 = n2++;
        int n7 = (by & 1) << 4;
        by = byArray[n++];
        byArray2[n6] = this.ALPAHBETS[n7 | by >>> 4 & 0xF];
        int n8 = n2++;
        int n9 = (by & 0xF) << 1;
        by = byArray[n++];
        byArray2[n8] = this.ALPAHBETS[n9 | by >>> 7 & 1];
        byArray2[n2++] = this.ALPAHBETS[by >>> 2 & 0x1F];
        int n10 = n2++;
        int n11 = (by & 3) << 3;
        by = byArray[n];
        byArray2[n10] = this.ALPAHBETS[n11 | by >>> 5 & 7];
        byArray2[n2] = this.ALPAHBETS[by & 0x1F];
    }

    private final void encode4bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.ALPAHBETS[by >>> 3 & 0x1F];
        int n4 = n2++;
        int n5 = (by & 7) << 2;
        by = byArray[n++];
        byArray2[n4] = this.ALPAHBETS[n5 | by >>> 6 & 3];
        byArray2[n2++] = this.ALPAHBETS[by >>> 1 & 0x1F];
        int n6 = n2++;
        int n7 = (by & 1) << 4;
        by = byArray[n++];
        byArray2[n6] = this.ALPAHBETS[n7 | by >>> 4 & 0xF];
        int n8 = n2++;
        int n9 = (by & 0xF) << 1;
        by = byArray[n];
        byArray2[n8] = this.ALPAHBETS[n9 | by >>> 7 & 1];
        byArray2[n2++] = this.ALPAHBETS[by >>> 2 & 0x1F];
        byArray2[n2++] = this.ALPAHBETS[(by & 3) << 3];
        byArray2[n2] = 61;
    }

    private final void encode3bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.ALPAHBETS[by >>> 3 & 0x1F];
        int n4 = n2++;
        int n5 = (by & 7) << 2;
        by = byArray[n++];
        byArray2[n4] = this.ALPAHBETS[n5 | by >>> 6 & 3];
        byArray2[n2++] = this.ALPAHBETS[by >>> 1 & 0x1F];
        int n6 = n2++;
        int n7 = (by & 1) << 4;
        by = byArray[n];
        byArray2[n6] = this.ALPAHBETS[n7 | by >>> 4 & 0xF];
        byArray2[n2++] = this.ALPAHBETS[(by & 0xF) << 1];
        for (int i = 0; i < 3; ++i) {
            byArray2[n2++] = 61;
        }
    }

    private final void encode2bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n++];
        byArray2[n3] = this.ALPAHBETS[by >>> 3 & 0x1F];
        int n4 = n2++;
        int n5 = (by & 7) << 2;
        by = byArray[n];
        byArray2[n4] = this.ALPAHBETS[n5 | by >>> 6 & 3];
        byArray2[n2++] = this.ALPAHBETS[by >>> 1 & 0x1F];
        byArray2[n2++] = this.ALPAHBETS[(by & 1) << 4];
        for (int i = 0; i < 4; ++i) {
            byArray2[n2++] = 61;
        }
    }

    private final void encode1byte(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2++;
        byte by = byArray[n];
        byArray2[n3] = this.ALPAHBETS[by >>> 3 & 0x1F];
        byArray2[n2++] = this.ALPAHBETS[(by & 7) << 2];
        for (int i = 0; i < 6; ++i) {
            byArray2[n2++] = 61;
        }
    }

    private final void decode5bytes(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        int n4 = n2++;
        int n5 = n++;
        n3 = this.pos(byArray[n++]);
        byArray2[n4] = (byte)(this.pos(byArray[n5]) << 3 | n3 >>> 2 & 7);
        int n6 = n2++;
        int n7 = (n3 & 3) << 6 | this.pos(byArray[n++]) << 1;
        n3 = this.pos(byArray[n++]);
        byArray2[n6] = (byte)(n7 | n3 >>> 4 & 1);
        int n8 = n2++;
        int n9 = (n3 & 0xF) << 4;
        n3 = this.pos(byArray[n++]);
        byArray2[n8] = (byte)(n9 | n3 >>> 1 & 0xF);
        int n10 = n2++;
        int n11 = (n3 & 1) << 7 | this.pos(byArray[n++]) << 2;
        n3 = this.pos(byArray[n++]);
        byArray2[n10] = (byte)(n11 | n3 >>> 3 & 3);
        byArray2[n2] = (byte)((n3 & 7) << 5 | this.pos(byArray[n]));
    }

    private final void decode1to4bytes(int n, byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = 0;
        int n5 = n3++;
        int n6 = n2++;
        n4 = this.pos(byArray[n2++]);
        byArray2[n5] = (byte)(this.pos(byArray[n6]) << 3 | n4 >>> 2 & 7);
        if (n == 1) {
            CodecUtils.sanityCheckLastPos(n4, 3);
            return;
        }
        int n7 = n3++;
        int n8 = (n4 & 3) << 6 | this.pos(byArray[n2++]) << 1;
        n4 = this.pos(byArray[n2++]);
        byArray2[n7] = (byte)(n8 | n4 >>> 4 & 1);
        if (n == 2) {
            CodecUtils.sanityCheckLastPos(n4, 15);
            return;
        }
        int n9 = n3++;
        int n10 = (n4 & 0xF) << 4;
        n4 = this.pos(byArray[n2++]);
        byArray2[n9] = (byte)(n10 | n4 >>> 1 & 0xF);
        if (n == 3) {
            CodecUtils.sanityCheckLastPos(n4, 1);
            return;
        }
        int n11 = (n4 & 1) << 7 | this.pos(byArray[n2++]) << 2;
        n4 = this.pos(byArray[n2]);
        byArray2[n3] = (byte)(n11 | n4 >>> 3 & 3);
        CodecUtils.sanityCheckLastPos(n4, 7);
    }

    @Override
    public final byte[] decode(byte[] byArray, int n) {
        int n2;
        int n3;
        if (n % 8 != 0) {
            throw new IllegalArgumentException("Input is expected to be encoded in multiple of 8 bytes but found: " + n);
        }
        int n4 = 0;
        for (int i = n - 1; n4 < 6 && i > -1 && byArray[i] == 61; --i, ++n4) {
        }
        switch (n4) {
            case 0: {
                n3 = 5;
                break;
            }
            case 1: {
                n3 = 4;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
            case 6: {
                n3 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number of paddings " + n4);
            }
        }
        byte[] byArray2 = new byte[n / 8 * 5 - (5 - n3)];
        int n5 = 0;
        for (n2 = 0; n2 < byArray2.length - n3 % 5; n2 += 5) {
            this.decode5bytes(byArray, n5, byArray2, n2);
            n5 += 8;
        }
        if (n3 < 5) {
            this.decode1to4bytes(n3, byArray, n5, byArray2, n2);
        }
        return byArray2;
    }

    protected abstract int pos(byte var1);
}

